/*$Id: sprtabotpw_r.c,v 1.21 2013/09/26 09:46:55 sasa Exp $*/
/*13.01.2020	26.05.2016	Белых А.И.	sprtabotpw_r.c
Расчёт отчёта 
*/
#include <errno.h>
#include "buhg_g.h"
#include "sprtabotpw.h"
#include "zarrsovw.h"
class sprtabotpw_r_data
 {

  public:

  GtkWidget *knopka;
  GtkWidget *window;
  GtkWidget *label;
  GtkWidget *bar;
  GtkWidget *view;
  GtkTextBuffer *buffer;
  class iceb_u_str name_window;

  class sprtabotp_poi *rp;
  class spis_oth *oth;  
  
  short kon_ras; //0-расчёт завершен 1-нет
  int voz;

  sprtabotpw_r_data()
   {
    voz=1;
    kon_ras=1;
   }
 };
#if 0
###########################33
class sprtabotp_dat
 {
  public:
   class iceb_u_double sumanmes;
   class iceb_u_spisok DATAI; //Список дат м.год индексации
   class iceb_u_double KOF; //Коффициенты индексации по датам
   class iceb_u_double sumanvr; //Суммы не входящие в расчёт
   class iceb_u_double sumanvrxr; //Суммы не входящие в расчёт хозрасчёт
   class iceb_u_double sumanmesxr; //Сумма начисленная хозрасчёт
   class iceb_u_double sumanvi; //Сумма не входящая в расчёт индексации отпускных
   class iceb_u_double sumanvixr; //Сумма не входящая в расчёт индексации отпускных хозрасчёта
   class iceb_u_double sumanmesbu;
   class iceb_u_double sumanvrbu; //Суммы не входящие в расчёт бюджет
   class iceb_u_double sumanvibu; //Сумма не входящая в расчёт индексации отпускных бюджета
   class iceb_u_int  kolkd; //Количество календарных дней в месяце
   class iceb_u_int  kol_pd; //Количество праздничных дней в месяце
   class iceb_u_int  kolkd_vdr; //Количество календарных дней взятых для расчёта
   class iceb_u_int skodnvr; /*список кодов начислений вошедших в расчёт*/
   class iceb_u_double sum_vr;

   class iceb_u_str fio;
   class iceb_u_str dolg;
   class iceb_u_str kodpodr;     
   class iceb_u_str naipod;
 };
#################################
#endif

class sprtabotp_dat
 {
  public:

   class iceb_u_double sumanmes; /*общая сумма начислений*/
   class iceb_u_double sumanvr; //Суммы не входящие в расчёт
   class iceb_u_double sumanvi; //Сумма не входящая в расчёт индексации отпускных
   
   class iceb_u_double sumanvrxr; //Суммы не входящие в расчёт хозрасчёт
   class iceb_u_double sumanmesxr; //Сумма начисленная хозрасчёт
   class iceb_u_double sumanvixr; //Сумма не входящая в расчёт индексации отпускных хозрасчёта

   class iceb_u_double sumanmesbu; /*Сумма начислений бюджета*/
   class iceb_u_double sumanvrbu; //Суммы не входящие в расчёт бюджет
   class iceb_u_double sumanvibu; //Сумма не входящая в расчёт индексации отпускных бюджета

   class iceb_u_int  kolkd; //Количество календарных дней в месяце
   class iceb_u_int  kol_pd; //Количество праздничных дней в месяце
   class iceb_u_int  kolkd_vdr; //Количество календарных дней взятых для расчёта
   class iceb_u_int skodnvr; /*список кодов начислений вошедших в расчёт*/
   class iceb_u_double sum_vr;

   class zarpkp_dat kpo; /*общая квартальная премия*/
   class zarpkp_dat kpxr; /*хозрасчётная квартальная премия*/
   class zarpkp_dat kpbu; /*бюджетная квартальная премия*/
   
   
      

   class iceb_u_str fio;
   class iceb_u_str dolg;
   class iceb_u_str kodpodr;     
   class iceb_u_str naipod;
 };

gboolean   sprtabotpw_r_key_press(GtkWidget *widget,GdkEventKey *event,class sprtabotpw_r_data *data);
gint sprtabotpw_r1(class sprtabotpw_r_data *data);
void  sprtabotpw_r_v_knopka(GtkWidget *widget,class sprtabotpw_r_data *data);


extern SQL_baza bd;
extern char	*shetb; /*Бюджетные счета начислений*/
extern FILE *zar_pr_ffp;

int sprtabotpw_r(class sprtabotp_poi *rek,class spis_oth *oth,GtkWidget *wpredok)
{
char strsql[512];
class iceb_u_str repl;
class sprtabotpw_r_data data;
int gor=0;
int ver=0;
data.name_window.plus(__FUNCTION__);
data.oth=oth;
data.rp=rek;

data.window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_modal(GTK_WINDOW(data.window),TRUE);
gtk_window_set_position( GTK_WINDOW(data.window),ICEB_POS_CENTER);
if(iceb_sizwr(data.name_window.ravno(),&gor,&ver) == 0)
   gtk_window_set_default_size (GTK_WINDOW  (data.window),gor,ver);
else
  gtk_window_set_default_size (GTK_WINDOW  (data.window),400,400);

sprintf(strsql,"%s %s",iceb_get_namesystem(),gettext("Расчёт отпускных"));
gtk_window_set_title(GTK_WINDOW(data.window),strsql);

g_signal_connect(data.window,"delete_event",G_CALLBACK(gtk_widget_destroy),NULL);
g_signal_connect(data.window,"destroy",G_CALLBACK(gtk_main_quit),NULL);
g_signal_connect_after(data.window,"key_press_event",G_CALLBACK(sprtabotpw_r_key_press),&data);

if(wpredok != NULL)
 {
  gdk_window_set_cursor(gtk_widget_get_window(wpredok),gdk_cursor_new_for_display(gtk_widget_get_display(wpredok),ICEB_CURSOR_GDITE));
  //Удерживать окно над породившем его окном всегда
  gtk_window_set_transient_for(GTK_WINDOW(data.window),GTK_WINDOW(wpredok));
  //Закрыть окно если окно предок удалено
  gtk_window_set_destroy_with_parent(GTK_WINDOW(data.window),TRUE);
 }

GtkWidget *vbox=gtk_box_new(GTK_ORIENTATION_VERTICAL, 2);
gtk_box_set_homogeneous (GTK_BOX(vbox),FALSE); //Устанавливает одинакоый ли размер будут иметь упакованные виджеты-TRUE-одинаковые FALSE-нет

gtk_container_add(GTK_CONTAINER(data.window), vbox);

data.label=gtk_label_new(gettext("Ждите !!!"));

gtk_box_pack_start(GTK_BOX(vbox),data.label,FALSE,FALSE,0);

repl.plus(gettext("Расчёт отпускных"));
sprintf(strsql,"%s:%s %s\n",gettext("База данных"),iceb_get_namebase(),iceb_get_pnk("00",0,wpredok));
repl.ps_plus(strsql);

GtkWidget *label=gtk_label_new(repl.ravno());

gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

data.view=gtk_text_view_new();

gtk_text_view_set_editable(GTK_TEXT_VIEW(data.view),FALSE); //Запрет на редактирование текста

data.buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(data.view));

GtkWidget *sw=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);
gtk_container_add(GTK_CONTAINER(sw),data.view);


data.bar=gtk_progress_bar_new();
gtk_progress_bar_set_show_text(GTK_PROGRESS_BAR(data.bar),TRUE); /*Показывать текст в строке*/



gtk_box_pack_start (GTK_BOX (vbox), data.bar, FALSE, FALSE, 2);



sprintf(strsql,"F10 %s",gettext("Выход"));
data.knopka=gtk_button_new_with_label(strsql);
gtk_widget_set_tooltip_text(data.knopka,gettext("Завершение работы в этом окне"));
g_signal_connect(data.knopka,"clicked",G_CALLBACK(sprtabotpw_r_v_knopka),&data);
gtk_widget_set_name(data.knopka,iceb_u_inttochar(0));
gtk_box_pack_start (GTK_BOX (vbox), data.knopka, FALSE, FALSE, 2);

gtk_widget_set_sensitive(GTK_WIDGET(data.knopka),FALSE);//Недоступна

gtk_widget_show_all(data.window);


//gtk_window_set_decorated(GTK_WINDOW(data.window),FALSE); //Убирает рамку вокруг окна

//gtk_widget_set_sensitive(GTK_WIDGET(data.knopka),FALSE);//Недоступна

g_idle_add((GSourceFunc)sprtabotpw_r1,&data);

gtk_main();

if(wpredok != NULL)
  gdk_window_set_cursor(gtk_widget_get_window(wpredok),gdk_cursor_new_for_display(gtk_widget_get_display(wpredok),ICEB_CURSOR));

return(data.voz);
}
/*****************************/
/*Обработчик нажатия кнопок  */
/*****************************/
void  sprtabotpw_r_v_knopka(GtkWidget *widget,class sprtabotpw_r_data *data)
{
if(data->kon_ras == 1)
 return;
iceb_sizww(data->name_window.ravno(),data->window);
gtk_widget_destroy(data->window);
return;
}
/*********************************/
/*Обработка нажатия клавиш       */
/*********************************/

gboolean   sprtabotpw_r_key_press(GtkWidget *widget,GdkEventKey *event,class sprtabotpw_r_data *data)
{
switch(event->keyval)
 {
  case GDK_KEY_Escape:
  case GDK_KEY_F10:
    g_signal_emit_by_name(data->knopka,"clicked");
    break;
 }
return(TRUE);
}



/*************************************/
/*поиск в месяце предыдущем началу расчёта отпускных в счёт месяца начала расчёта*/
/*********************************/

double sprtabotp_po(int tabn,class sprtabotp_poi *rp,const char *kod_otp,int metka_mes,
int metka_b, //0-общий 1-бюджет 2-хозрасчёт
GtkWidget *wpredok)
{
double suma_otp=0.;
char strsql[1024];
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;
short dp=1,mp=rp->mn,gp=rp->gn;
short den=1,mes=rp->mn,god=rp->gn;

iceb_u_dpm(&dp,&mp,&gp,4);
if(metka_mes == 1)
 iceb_u_dpm(&den,&mes,&god,3);

sprintf(strsql,"select knah,suma,shet from Zarp where tabn=%d \
and datz >= '%04d-%d-%d' and datz <='%04d-%d-%d' and prn='1' and suma <> 0.\
 and godn=%d and mesn=%d",
tabn,gp,mp,1,gp,mp,31,god,mes);

//printw("%s-%s\n",__FUNCTION__,strsql);
//OSTANOV();

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  return(0.);
 }

while(cur.read_cursor(&row) != 0)
 {
  if(metka_b == 1)
   if(iceb_u_proverka(shetb,row[2],0,1) != 0)
    continue;
  if(metka_b == 2)
   if(iceb_u_proverka(shetb,row[2],0,1) == 0)
    continue;
          
  if(iceb_u_proverka(row[0],kod_otp,0,1) == 0)
   {
    sprintf(strsql,"%s-Сумма отпускных предыдущего месяца=%s\n",__FUNCTION__,row[1]);
    zar_pr_insw(strsql,wpredok);
    
    suma_otp+=atof(row[1]);
   }

 }
 
return(suma_otp);

}


/********************************/
/* Распечатка результата        */
/*возвращает сумму последней колонки в таблице*/
/*без коэффициентов действует с 12.12.2020*/
/********************************/
double rasrez2(int tabn,
class sprtabotp_poi *rp,
class sprtabotp_dat *dt,
class iceb_u_double *sumanmes,
class iceb_u_double *sumanvr,
int metka, //0-общий 1-бюджет 2-хозрасчёт
class iceb_u_double *sumanvi, //Массив сумм не входящих в расчёт индексации
class zarpkp_dat *kp,
FILE *ff,
GtkWidget *wpredok)
{
int nomkod=0;
int nommes=0;
char strsql[2048];
short d,m,g;
SQL_str row;
int kolkdi=0;
char bros[1024];
class SQLCURSOR curr;
int metka_kp=0; /*метка квартальной премии 1-значит плюс две колонки (первая колонка начисленная квартальная премия, вторая распределённая по месяцам квартальная премия*/

/*расчитываем распределение квартальной премии по месяцам квартала*/
if(rp->kodkp.ravno_atoi() != 0)
 {
  zarpkpw(rp->mn,rp->gn,rp->mk,rp->gk,tabn,kp,rp->kolmes,rp->kodkp.ravno(),rp->kod_tab_kp.ravno(),wpredok);

  /*узнаём есть ли квартальная премия*/
  if(kp->suma_kp_mes.suma() != 0. || kp->suma_kp.suma() != 0.)
   metka_kp=2;
 }


//Вычисляем количество колонок
int kolkol=0;
int kolkodnvr=iceb_u_pole2(rp->kodnvr.ravno(),',');

for(nomkod=0; nomkod < kolkodnvr ; nomkod++)
 if(sumanvr->suma_kol(rp->kolmes,kolkodnvr,nomkod) != 0.)
   kolkol++;

/************************************
int kolkodnvrind=iceb_u_pole2(rp->kodnvrind.ravno(),',');

for(nomkod=0; nomkod < kolkodnvrind ; nomkod++)
 if(sumanvi->suma_kol(rp->kolmes,kolkodnvrind,nomkod) != 0.)
   kolkol++;
*******************************/


char stroka[54+(kolkol+metka_kp-1)*11];
memset(stroka,'\0',sizeof(stroka));
memset(stroka,'-',sizeof(stroka)-1);

class iceb_u_str kod_otp("");
iceb_poldan("Коды начислений отпускных",&kod_otp,"zarotp.alx",wpredok);

time_t  tmm;
time(&tmm);
iceb_zagolov(gettext("Расчётный лист на оплату отпускных"),1,rp->mn,rp->gn,rp->dk,rp->mk,rp->gk,ff,wpredok);

fprintf(ff,"\n%s:%d\n",gettext("Табельный номер"),tabn);
fprintf(ff,"%s:%s\n",gettext("Фамилия Имя Отчество"),dt->fio.ravno());
fprintf(ff,"%s:%s\n",gettext("Должность"),dt->dolg.ravno());
fprintf(ff,"%s:%s %s\n",gettext("Подразделение"),dt->kodpodr.ravno(),dt->naipod.ravno());
fprintf(ff,"%s:%s\n",gettext("Вид отпуска"),rp->vid_otp.ravno());
fprintf(ff,"%s:%s\n",gettext("Приказ"),rp->prikaz.ravno());
fprintf(ff,"%s:%s\n",gettext("Период з"),rp->period.ravno());
fprintf(ff,"%s:%s\n",gettext("Количество дней отпуска"),rp->kol_dnei.ravno());
fprintf(ff,"\n");

if(rp->kodkp.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код квартальной премии"),rp->kodkp.ravno());

if(rp->kodt_nvr.ravno()[0] != '\0')
 fprintf(ff,"%s:%s\n",gettext("Коды табеля не входящие в расчёт"),rp->kodt_nvr.ravno());
 
if(metka == 1)
  fprintf(ff,"%s.\n",gettext("Бюджет"));

if(metka == 2)
  fprintf(ff,"%s.\n",gettext("Хозрасчёт"));

int metka_pk=iceb_poldan_vkl("Печать наименований кодов не входящих в расчёт","zarotp.alx",wpredok);

if(metka_pk == 1)
 {
  fprintf(ff,"%s:%.*s\n",
  gettext("Коды, которые не вошли в расчёт"),
  iceb_u_kolbait(60,rp->kodnvr.ravno()),
  rp->kodnvr.ravno());

  for(int nom=60; nom < iceb_u_strlen(rp->kodnvr.ravno()); nom+=90)
   fprintf(ff,"%.*s\n",
   iceb_u_kolbait(90,iceb_u_adrsimv(nom,rp->kodnvr.ravno())),
   iceb_u_adrsimv(nom,rp->kodnvr.ravno()));
      
 }
else
 {
  if(kolkodnvr != 0)
   {
    class iceb_u_str kod("");
    class iceb_u_str naikod("");
    fprintf(ff,"%s:\n",gettext("Коды, которые не вошли в расчёт"));
    short shethik=0;
    char str_prom[1024];
    char str2[1024];
    
    for(nomkod=0; nomkod < kolkodnvr ; nomkod++)
     {
      if(iceb_u_polen(rp->kodnvr.ravno(),&kod,nomkod+1,',') != 0)
        kod.new_plus(rp->kodnvr.ravno());
      sprintf(strsql,"select naik from Nash where kod=%s",kod.ravno());
      if(sql_readkey(&bd,strsql,&row,&curr) == 1)
       naikod.new_plus(row[0]);    
      else
       naikod.new_plus("");  
      if(shethik == 0)
       {
        memset(str_prom,'\0',sizeof(str_prom));
        sprintf(str_prom,"%2s %-*.*s",
        kod.ravno(),
        iceb_u_kolbait(45,naikod.ravno()),iceb_u_kolbait(45,naikod.ravno()),naikod.ravno());
       }

      if(shethik == 1)
       {
        sprintf(str2,"  %2s %-*.*s",
        kod.ravno(),
        iceb_u_kolbait(45,naikod.ravno()),iceb_u_kolbait(45,naikod.ravno()),naikod.ravno());
        strcat(str_prom,str2);
       }


      
      shethik++;
      if(shethik == 2)
       {
        fprintf(ff,"%s\n",str_prom);
        shethik=0;
       }
    
    
     }
    if(shethik != 0)
        fprintf(ff,"%s\n",str_prom);

   }
 }

fprintf(ff,"\n");

fprintf(ff,"%s\n",stroka);

fprintf(ff,"%s",gettext(" Дата  |К.д|П.д|В.р|Начислено |"));
//Печатаем коды не входящие в расчёт
for(nomkod=0; nomkod < kolkodnvr ; nomkod++)
 {
  if(sumanvr->suma_kol(rp->kolmes,kolkodnvr,nomkod) == 0.)
    continue;
    
  if(iceb_u_polen(rp->kodnvr.ravno(),bros,sizeof(bros),nomkod+1,',') != 0)
    strcpy(bros,rp->kodnvr.ravno());

  sprintf(strsql,"select naik from Nash where kod=%d",atoi(bros));
  if(iceb_sql_readkey(strsql,&row,&curr,wpredok) == 1)
   sprintf(strsql,"%s %s",bros,row[0]);
  else
   strcpy(strsql,bros);

  fprintf(ff,"%*.*s|",
  iceb_u_kolbait(10,strsql),
  iceb_u_kolbait(10,strsql),
  strsql);
 }

if(metka_kp > 0)
 {
  fprintf(ff,"К.п.нарах.|К.п.місяч.|");
 }

fprintf(ff,"%*.*s|",
iceb_u_kolbait(10,gettext("В расчёт")),iceb_u_kolbait(10,gettext("В расчёт")),gettext("В расчёт"));


fprintf(ff,"\n%s\n",stroka);

d=1; m=rp->mn; g=rp->gn;
double itog=0.;
double itog1=0.;
int kold_vdr=0;
int itogo_dni[3];
double v_rashet=0.;
double itogo_v_rashet=0.;
memset(itogo_dni,'\0',sizeof(itogo_dni));
double suma_kp=0.,suma_kp_mes=0.;
for(nommes=0; nommes < rp->kolmes; nommes++)
 {

  fprintf(ff,"%02d.%04d|%3d|%3d|%3d|%10.2f|",m,g,dt->kolkd.ravno(nommes),dt->kol_pd.ravno(nommes),dt->kolkd_vdr.ravno(nommes)-dt->kol_pd.ravno(nommes),sumanmes->ravno(nommes));
  kolkdi+=dt->kolkd.ravno(nommes);
  kold_vdr+=dt->kolkd_vdr.ravno(nommes);
  itog1+=sumanmes->ravno(nommes);
  itog=0.;
  itogo_dni[0]+=dt->kolkd.ravno(nommes);
  itogo_dni[1]+=dt->kol_pd.ravno(nommes);
  itogo_dni[2]+=dt->kolkd_vdr.ravno(nommes)-dt->kol_pd.ravno(nommes);


  for(nomkod=0; nomkod < kolkodnvr ; nomkod++)
   {
    if(sumanvr->suma_kol(rp->kolmes,kolkodnvr,nomkod) == 0.)
      continue;
    double sss=sumanvr->ravno(nommes*kolkodnvr+nomkod);
    if(sss != 0.)
     fprintf(ff,"%10.2f|",sss);
    else
     fprintf(ff,"%10s|","");

    itog+=sss;
   }

  double otp=0.;

  if(nommes == 0 || nommes == 1)/*прибавляем сумму отпускных в счёт этого месяца*/
   {

    otp=sprtabotp_po(tabn,rp,kod_otp.ravno(),nommes,metka,wpredok);
    
   }

  suma_kp=kp->suma_kp.ravno(nommes);
  suma_kp_mes=kp->suma_kp_mes.ravno(nommes);
  
  if(metka_kp > 0)
   {
    if(suma_kp != 0.)
     fprintf(ff,"%10.2f|",suma_kp);
    else
     fprintf(ff,"%10s|","");

    if(suma_kp_mes != 0.)
     fprintf(ff,"%10.2f|",suma_kp_mes);
    else
     fprintf(ff,"%10s|","");
     
   }


  /*печатаем колонку В расчёт*/
  v_rashet=sumanmes->ravno(nommes)-itog+otp-suma_kp+suma_kp_mes;
  itogo_v_rashet+=v_rashet;

  fprintf(ff,"%10.2f|",v_rashet);

  fprintf(ff,"\n");
  iceb_u_dpm(&d,&m,&g,3);
 }

fprintf(ff,"%s\n",stroka);

//Печатаем итоговую строку
fprintf(ff,"%*s:%3d %3d %3d %10.2f",iceb_u_kolbait(7,gettext("Итого")),gettext("Итого"),itogo_dni[0],itogo_dni[1],itogo_dni[2],itog1);
for(nomkod=0; nomkod < kolkodnvr ; nomkod++)
 {
   if(sumanvr->suma_kol(rp->kolmes,kolkodnvr,nomkod) == 0.)
    continue;
  itog=0.;
  for(nommes=0; nommes < rp->kolmes; nommes++)
    itog+=sumanvr->ravno(nommes*kolkodnvr+nomkod);

  fprintf(ff," %10.2f",itog);
  itog1-=itog;

 }

/*в итоговую строку печатаем колонку начисленной квартальной премии и распределённой по месяцам*/

if(metka_kp > 0)
 {
  suma_kp=kp->suma_kp.suma();
  suma_kp_mes=kp->suma_kp_mes.suma();

  if(suma_kp != 0.)
   fprintf(ff," %10.2f",suma_kp);
  else
   fprintf(ff," %10s","");

  if(suma_kp_mes != 0.)
   fprintf(ff," %10.2f",suma_kp_mes);
  else
   fprintf(ff," %10s","");
  
 }



fprintf(ff," %10.2f",itogo_v_rashet);


fprintf(ff,"\n");

double suma_otp=0.;
class iceb_u_str kol_d(""); 

int kol_pol=iceb_u_pole2(rp->kol_dnei.ravno(),',');

if(kol_pol > 0)
 {
  fprintf(ff,"\n");
  for(int nom=1;nom <= kol_pol ; nom++)
   {
    iceb_u_polen(rp->kol_dnei.ravno(),&kol_d,nom,',');
    if(kol_d.ravno_atoi() == 0)
     continue;
    suma_otp=itogo_v_rashet/itogo_dni[2]*kol_d.ravno_atoi();
    fprintf(ff,"%.2f/%d*%d=%.2f\n",itogo_v_rashet,itogo_dni[2],kol_d.ravno_atoi(),suma_otp);
    
   }
 }
else
 if(rp->kol_dnei.getdlinna() > 1)
  {
   suma_otp=itogo_v_rashet/itogo_dni[2]*rp->kol_dnei.ravno_atoi();
   fprintf(ff,"\n%.2f/%d*%d=%.2f\n",itogo_v_rashet,itogo_dni[2],rp->kol_dnei.ravno_atoi(),suma_otp);
  }
fprintf(ff,"\n-----------------------------------------------------\n");
fprintf(ff,"-----------------------------------------------------\n");
fprintf(ff,"-----------------------------------------------------\n");
fprintf(ff,"-----------------------------------------------------\n");
fprintf(ff,"-----------------------------------------------------\n");


return(itogo_v_rashet);

}

/*********************************************/
/*расчёт одного табельного номера*/
/**********************************************/
double sprtabotp_r1tn(int tabn,class sprtabotp_poi *rp,
class sprtabotp_dat *dt,
class iceb_zarrsov *svod_otvr, /*свод по отработанному времени*/
FILE *ff,
FILE *ff_prot,
GtkWidget *wpredok)
{
char strsql[1024];
int kolstr=0;
class SQLCURSOR cur,cur1,curr;
SQL_str row,row1;


int metka_dkn=0; /*метка присутствия начислений для дополнительных кодов*/



sprintf(strsql,"select fio,dolg,podr,datn from Kartb where tabn=%d",tabn);
if(sql_readkey(&bd,strsql,&row,&curr) != 1)
 {
  sprintf(strsql,"%s %d !",gettext("Не найден табельный номер"),tabn);
  iceb_menu_soob(strsql,wpredok);
  return(-1.);
 }
dt->fio.new_plus(row[0]);
dt->dolg.new_plus(row[1]);
dt->kodpodr.new_plus(row[2]);

//Читаем наименование подразделения
sprintf(strsql,"select naik from Podr where kod=%s",dt->kodpodr.ravno());
if(sql_readkey(&bd,strsql,&row,&curr) == 1)
 dt->naipod.new_plus(row[0]);
else
 dt->naipod.new_plus("");



int kol_kd=iceb_u_pole2(rp->kodn_d_dk.ravno(),',');
if(kol_kd == 0 && rp->kodn_d_dk.ravno()[0] != '\0')
  kol_kd=1;
/*опрeделяем есть ли начисления для дополнительных кодов*/
for(int nom=0; nom < kol_kd; nom++)
 {
  int kdn=0;
  
  if(kol_kd == 1)
   kdn=rp->kodn_d_dk.ravno_atoi();
  else
   iceb_u_polen(rp->kodn_d_dk.ravno(),&kdn,nom+1,',');
    
  sprintf(strsql,"select datz,knah,suma,shet from Zarp where tabn=%d \
and datz >= '%04d-%d-%d' and datz <='%04d-%d-%d' and prn='1' and suma <> 0. and knah=%d limit 1",
  tabn,rp->gn,rp->mn,1,rp->gk,rp->mk,rp->dk,kdn);
  if(iceb_sql_readkey(strsql,wpredok) == 1)
   {
    metka_dkn=1;
    break;
   }
 }

if(metka_dkn == 1)
 {
  rp->kodnvr.z_plus(rp->kodnvr_d.ravno());
 }



int kolkodnvr=iceb_u_pole2(rp->kodnvr.ravno(),',');
if(kolkodnvr == 0 && rp->kodnvr.ravno()[0] != '\0')
  kolkodnvr=1;

int kolkodnvrind=iceb_u_pole2(rp->kodnvrind.ravno(),',');
if(kolkodnvrind == 0 && rp->kodnvrind.ravno()[0] != '\0')
  kolkodnvrind=1;
  

//Читаем коэффициенты индексации

//readki(&dt->DATAI,&dt->KOF); /*в расчёте после 12.12.2020 г. индексация не применяется*/


dt->sumanmes.make_class(rp->kolmes);

dt->sumanvr.make_class(rp->kolmes*kolkodnvr);

dt->sumanmesxr.make_class(rp->kolmes);

dt->sumanvrxr.make_class(rp->kolmes*kolkodnvr);


dt->sumanmesbu.make_class(rp->kolmes);

dt->sumanvrbu.make_class(rp->kolmes*kolkodnvr);

dt->sumanvi.make_class(rp->kolmes*kolkodnvrind);

dt->sumanvixr.make_class(rp->kolmes*kolkodnvrind);

dt->sumanvibu.make_class(rp->kolmes*kolkodnvrind);

dt->kolkd.make_class(rp->kolmes);

dt->kol_pd.make_class(rp->kolmes);

dt->kolkd_vdr.make_class(rp->kolmes);

dt->kpo.suma_kp.make_class(rp->kolmes);
dt->kpo.suma_kp_mes.make_class(rp->kolmes);

dt->kpxr.suma_kp.make_class(rp->kolmes);
dt->kpxr.suma_kp_mes.make_class(rp->kolmes);

dt->kpbu.suma_kp.make_class(rp->kolmes);
dt->kpbu.suma_kp_mes.make_class(rp->kolmes);



sprintf(strsql,"select datz,knah,suma,shet,kom from Zarp where tabn=%d \
and datz >= '%04d-%d-%d' and datz <='%04d-%d-%d' and prn='1' and suma <> 0. order by datz asc",
tabn,rp->gn,rp->mn,1,rp->gk,rp->mk,rp->dk);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одной записи !"),wpredok);
  return(1);
 }
int kolstr1=0;
short d=0,m=0,g=0;
short dnr=0,mnr=0,gnr=0;
double suma=0.;
class iceb_u_str metka_kom("");

while(cur.read_cursor(&row) != 0)
 {
//  strzag(LINES-1,0,kolstr,++kolstr1);

  iceb_u_rsdat(&d,&m,&g,row[0],2);
  if(dnr != 0 && dnr != 1) //Если первый месяц отработан не полностью в расчёт его не берем
    if(mnr == m && gnr == g)
      continue;

  suma=atof(row[2]);

  int nommes=iceb_u_period(1,rp->mn,rp->gn,d,m,g,1)-1;    

  dt->sumanmes.plus(suma,nommes);

  if(iceb_u_proverka(shetb,row[3],0,1) == 0)
    dt->sumanmesbu.plus(suma,nommes);
  else 
    dt->sumanmesxr.plus(suma,nommes);
  int nomkod=0;
  if(iceb_u_proverka(rp->kodnvr.ravno(),row[1],0,1) == 0)
   {
    iceb_u_pole1(rp->kodnvr.ravno(),row[1],',',0,&nomkod);
    dt->sumanvr.plus(suma,nommes*kolkodnvr+nomkod);
    if(iceb_u_proverka(shetb,row[3],0,1) == 0)
      dt->sumanvrbu.plus(suma,nommes*kolkodnvr+nomkod);
    else 
      dt->sumanvrxr.plus(suma,nommes*kolkodnvr+nomkod);

   }
  else
   {
    if(dt->skodnvr.find(row[1]) < 0)
     dt->skodnvr.plus(row[1]);
   }

  if(iceb_u_proverka(rp->kodnvrind.ravno(),row[1],0,1) == 0)
   {
    iceb_u_pole1(rp->kodnvrind.ravno(),row[1],',',0,&nomkod);
    dt->sumanvi.plus(suma,nommes*kolkodnvrind+nomkod);
    if(iceb_u_proverka(shetb,row[3],0,1) == 0)
      dt->sumanvibu.plus(suma,nommes*kolkodnvrind+nomkod);
    else 
      dt->sumanvixr.plus(suma,nommes*kolkodnvrind+nomkod);

   }

  if(iceb_u_proverka(rp->kodkp.ravno(),row[1],0,1) == 0)
   {
    dt->kpo.suma_kp.plus(suma,nommes);
    if(iceb_u_proverka(shetb,row[3],0,1) == 0)
     dt->kpbu.suma_kp.plus(suma,nommes);
    else
     dt->kpxr.suma_kp.plus(suma,nommes);

    /*записываем в счёт какого квартала, год квартала, сумма квартальной премии*/
    if(iceb_u_polen(row[4],&metka_kom,1,'-') == 0)
     {
      if(iceb_u_SRAV("кп",metka_kom.ravno(),0) == 0)
       {
        int nom_kv=0;
        int god_kv=0;
        iceb_u_polen(row[4],&nom_kv,2,'-');

        if(nom_kv < 1 || nom_kv > 4)
         fprintf(ff_prot,"%s-Неправильный номер квартала!\n",__FUNCTION__);
        else
         {
          iceb_u_polen(row[4],&god_kv,3,'-');
          sprintf(strsql,"%d|%d|%.2f|%s",nom_kv,god_kv,suma,iceb_u_datzap(row[0]));
          dt->kpo.kp.plus(strsql);          
          if(iceb_u_proverka(shetb,row[3],0,1) == 0)
           dt->kpbu.kp.plus(strsql);
          else
           dt->kpxr.kp.plus(strsql);
         } 
       }
      else
        fprintf(ff_prot,"%s-Неправильная метка коментария номера квартала!\n",__FUNCTION__);
     }
    else
     fprintf(ff_prot,"%s-Не введён квартал в счёт которого начислена премия!\n",__FUNCTION__);
   }

 }

/*Создаём масив для сумм начислений вошедших в расчёт*/
int kolih_kod=dt->skodnvr.kolih();
dt->sum_vr.make_class(kolih_kod*rp->kolmes);
kolstr1=0;
cur.poz_cursor(0);
int nommes=0,nomkod=0;
while(cur.read_cursor(&row) != 0)
 {
//  strzag(LINES-1,0,kolstr,++kolstr1);

  iceb_u_rsdat(&d,&m,&g,row[0],2);
  if(dnr != 0 && dnr != 1) //Если первый месяц отработан не полностью в расчёт его не берем
    if(mnr == m && gnr == g)
      continue;

  suma=atof(row[2]);

  nommes=iceb_u_period(1,rp->mn,rp->gn,d,m,g,1)-1;    
  if((nomkod=dt->skodnvr.find(row[1])) < 0)
   continue;
  dt->sum_vr.plus(suma,nommes*kolih_kod+nomkod);
 }

 
//Узнаем количество календарных дней
if(rp->gn != rp->gk)
  sprintf(strsql,"select kodt,god,mes,dnei,kdnei,has from Ztab where tabn=%d and \
((god > %d and god < %d) \
or (god=%d and mes >= %d) \
or (god=%d and mes <= %d)) order by god asc,mes asc",
  tabn,rp->gn,rp->gk,rp->gn,rp->mn,rp->gk,rp->mk);
else
  sprintf(strsql,"select kodt,god,mes,dnei,kdnei,has from Ztab where tabn=%d and \
god=%d and mes >= %d and mes <= %d order by god asc,mes asc",
  tabn,rp->gn,rp->mn,rp->mk);

//printw("%s\n",strsql);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
kolstr1=0;
d=1;
int nomvs=0;
int mes_z=0;
if(kolstr > 0)
while(cur.read_cursor(&row) != 0)
 {
//  strzag(LINES-1,0,kolstr,++kolstr1);
  
  g=atoi(row[1]);
  m=atoi(row[2]);
  nommes=iceb_u_period(1,rp->mn,rp->gn,d,m,g,1)-1;    
  dt->kolkd.plus(atoi(row[4]),nommes);

  if(iceb_u_proverka(rp->kodt_nvr.ravno(),row[0],0,1) != 0)
   dt->kolkd_vdr.plus(atoi(row[4]),nommes);

  /*узнаём количество праздничных дней в месяце*/
  if(mes_z != m)
   {
    sprintf(strsql,"select kpd from Zarskrdh where data='%04d-%02d-01'",g,m);
    if(iceb_sql_readkey(strsql,&row1,&cur1,wpredok) == 1)
     dt->kol_pd.plus(atoi(row1[0]),nommes);
    mes_z=m;
   }

  if(svod_otvr->kod.find(row[0]) < 0)
     svod_otvr->kod.plus(row[0]);

  sprintf(strsql,"%s|%02d.%04d",row[0],m,g);

  if((nomvs=svod_otvr->kod_mes_god.find(strsql)) < 0)
   svod_otvr->kod_mes_god.plus(strsql);

  svod_otvr->kolrd.plus(row[3],nomvs);    
  svod_otvr->kolkd.plus(row[4],nomvs);    
  svod_otvr->kolhs.plus(atof(row[5]),nomvs);    

 }



//Распечатываем общий итог
double sumai=rasrez2(tabn,rp,dt,&dt->sumanmes,&dt->sumanvr,0,&dt->sumanvi,&dt->kpo,ff,wpredok);
/**************
double rasrez2(int tabn,
class sprtabotp_poi *rp,
class sprtabotp_dat *dt,
class iceb_u_double *sumanmes,
class iceb_u_double *sumanvr,
int metka, //0-общий 1-бюджет 2-хозрасчёт
class iceb_u_double *sumanvi, //Массив сумм не входящих в расчёт индексации
class zarpkp_dat *kp,
FILE *ff,
GtkWidget *wpredok)
*****************/
return(sumai);
}




/**************************************************/
/*расчёт по нескольким табельным номерам*/
/***********************************************/
int sprtabotp_rntn(class sprtabotpw_r_data *data)
{
char strsql[1024];
class SQLCURSOR cur,cur1;
SQL_str row,row1;
int kolstr=0;


sprintf(strsql,"select distinct tabn from Zarp where datz >= '%04d-%02d-01' and \
datz <= '%04d-%02d-%02d' and prn = '1' and suma <> 0. order by tabn asc",
data->rp->gn,data->rp->mn,
data->rp->gk,data->rp->mk,data->rp->dk);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,data->window);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одной записи !"),data->window);
  return(1);
 }
int kolstr1=0;

char imaf_prot[64];
sprintf(imaf_prot,"otpp%d.lst",getpid());

if(zar_pr_startw(imaf_prot,data->window) != 0)
 return(1);
 
iceb_zagolov(gettext("Протокол хода расчёта отпускных"),1,data->rp->mn,data->rp->gn,data->rp->dk,data->rp->mk,data->rp->gk,zar_pr_ffp,data->window);

class iceb_fopen fil_sp;
char imaf_sp[64];
sprintf(imaf_sp,"otsp%d.lst",getpid());
if(fil_sp.start(imaf_sp,"w",data->window) != 0)
 return(1);

iceb_zagolov(gettext("Расчёт отпускных"),1,data->rp->mn,data->rp->gn,data->rp->dk,data->rp->mk,data->rp->gk,fil_sp.ff,data->window);



if(data->rp->tabnom.getdlinna() > 1)
 fprintf(fil_sp.ff,"%s:%s\n",gettext("Табельный номер"),data->rp->tabnom.ravno());

if(data->rp->kod_podr.getdlinna() > 1)
 fprintf(fil_sp.ff,"%s:%s\n",gettext("Код подразделения"),data->rp->kod_podr.ravno());
 
class sprtabotp_dat dt;

class iceb_fopen fil;
char imaf[64];
sprintf(imaf,"otp%d.lst",getpid());
if(fil.start(imaf,"w",data->window) != 0)
 return(1);

fprintf(fil.ff,"\x1B\x33%c\n",30); /*Уменьшаем межстрочный интервал*/


double itogo=0.;
while(cur.read_cursor(&row) != 0)
 {
//  strzag(LINES-1,0,kolstr,++kolstr1);
  
  if(iceb_u_proverka(data->rp->tabnom.ravno(),row[0],0,0) != 0)
   continue;

  sprintf(strsql,"select podr from Kartb where tabn=%d",atoi(row[0]));
  if(sql_readkey(&bd,strsql,&row1,&cur1) != 1)
   {
    sprintf(strsql,"%s-%s %d !",__FUNCTION__,gettext("Не найден табельный номер"),atoi(row[0]));
    iceb_menu_soob(strsql,data->window);
   }
  else
   {
    if(iceb_u_proverka(data->rp->kod_podr.ravno(),row1[0],0,0) != 0)
     continue;
   }

  class sprtabotp_dat dt;
  
  class iceb_zarrsov svod_otvr; /*свод по отработанному времени*/

  if(kolstr1 > 1)
   fprintf(fil.ff,"\f");
   
  double suma=sprtabotp_r1tn(atoi(row[0]),data->rp,&dt,&svod_otvr,fil.ff,zar_pr_ffp,data->window);
  itogo+=suma;

  sprintf(strsql,"%6s %-*s %12.2f \n",row[0],
  iceb_u_kolbait(40,dt.fio.ravno()),
  dt.fio.ravno(),suma);
  
  iceb_printw(strsql,data->buffer,data->view);

  fprintf(fil_sp.ff,"%6s %-*s %12.2f\n",row[0],
  iceb_u_kolbait(40,dt.fio.ravno()),
  dt.fio.ravno(),suma);
 }

sprintf(strsql,"%*s:%12.2f\n",
iceb_u_kolbait(47,gettext("Итого")),
gettext("Итого"),itogo);

iceb_printw(strsql,data->buffer,data->view);

fprintf(fil_sp.ff,"%*s:%12.2f\n",
iceb_u_kolbait(47,gettext("Итого")),
gettext("Итого"),itogo);


iceb_podpis(fil.ff,data->window);
fil.end();

zar_pr_endw(data->window);

iceb_podpis(fil_sp.ff,data->window);
fil_sp.end();

data->oth->spis_imaf.plus(imaf);
data->oth->spis_naim.plus(gettext("Расчёт отпускных"));
data->oth->spis_imaf.plus(imaf_sp);
data->oth->spis_naim.plus(gettext("Итоговый список"));
data->oth->spis_imaf.plus(imaf_prot);
data->oth->spis_naim.plus(gettext("Протокол хода расчёта"));

for(int nom=0; nom < data->oth->spis_imaf.kolih(); nom++)
 iceb_ustpeh(data->oth->spis_imaf.ravno(nom),3,data->window);

 
return(0);

}






/******************************************/
/******************************************/

gint sprtabotpw_r1(class sprtabotpw_r_data *data)
{
time_t vremn;
time(&vremn);
char strsql[1024];
class iceb_clock sss(data->window);

if(iceb_rsdatp1(&data->rp->mn,&data->rp->gn,data->rp->datan.ravno(),&data->rp->mk,&data->rp->gk,data->rp->datak.ravno(),data->window) != 0)
 {
  sss.clear_data();
  gtk_widget_destroy(data->window);
  return(FALSE);
 }


sprintf(strsql,"%d.%d%s => %d.%d%s\n",
data->rp->mn,data->rp->gn,gettext("г."),
data->rp->mk,data->rp->gk,gettext("г."));

iceb_printw(strsql,data->buffer,data->view);


data->rp->kolmes=iceb_u_period(1,data->rp->mn,data->rp->gn,data->rp->dk,data->rp->mk,data->rp->gk,1);

iceb_poldan("Коды не входящие в расчёт отпускных",&data->rp->kodnvr,"zarotp.alx",data->window);
iceb_poldan("Коды не входящие в расчёт индексации отпускных",&data->rp->kodnvrind,"zarotp.alx",data->window);
iceb_poldan("Коды табеля не входящие в расчёт",&data->rp->kodt_nvr,"zarotp.alx",data->window);
iceb_poldan("Дополнительные коды не входящие в расчёт",&data->rp->kodnvr_d,"zarotp.alx",data->window);
iceb_poldan("Коды начислений для дополнительных кодов",&data->rp->kodn_d_dk,"zarotp.alx",data->window);
iceb_poldan("Код квартальной премии",&data->rp->kodkp,"zarotp.alx",data->window);
iceb_poldan("Коды табеля для расчёта квартальной премии",&data->rp->kod_tab_kp,"zarotp.alx",data->window);


if(data->rp->tabnom.getdlinna() <= 1 || iceb_u_pole2(data->rp->tabnom.ravno(),',') > 0)
 {
  /*расчёт отпускных по нескольким табельных номерам*/
//  data->voz=sprtabotp_rntn(data);
 }
else
 {
  /*расчёт отпускных по одному табельному номеру*/
//  data->voz=sprtabotp_r(data);
 }



gtk_label_set_text(GTK_LABEL(data->label),gettext("Расчёт закончен"));

data->kon_ras=0;
gtk_widget_set_sensitive(GTK_WIDGET(data->knopka),TRUE);//доступна
gtk_widget_grab_focus(data->knopka);
gtk_widget_show_all(data->window);

iceb_printw_vr(vremn,data->buffer,data->view);

return(FALSE);

}
