/* $Id: b_prominvest.c,v 1.15 2013/09/26 09:46:46 sasa Exp $ */
/*18.03.2012	22.06.1998	Белых А.И.	b_prominvest.c
Формирование файла с реквизитами платежки для загрузки
в программу работы с банком для программы Клиент-банк Проминвест банка

*/
#include        <errno.h>
#include        "buhg_g.h"
#include        "dok4w.h"

extern class REC rec;
extern SQL_baza bd;

int b_prominvest(const char *tabl,GtkWidget *wpredok)
{
char		imaf[32];
FILE		*ff;
class iceb_u_str koment("");
double		bb;
short		vidp;
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }



sprintf(imaf,"plat.txt");
if((ff = fopen(imaf,"w")) == NULL)
 {
  iceb_er_op_fil(imaf,"",errno,wpredok);
  return(1);
 }

while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);
  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;

  /*Читаем комментарий*/
  
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);
   
  bb=rec.sumd*100.;
//printw(gettext("Сумма %.2f\n"),rec.sumd);



/*
Cтруктура тексового файла такая:

0    [35 ] Счет клиента(с учетом доступа к счетам на рабочем месте)
35   [ 3 ] Числовой идентификатор валюты счета клиента(например 980)
38   [15 ] МФО(BIC) банка корреспондента(например 300012)
53   [149] Наименование банка корреспондента(если есть МФО можно пробелы)
202  [35 ] Счет корреспондента
237  [ 3 ] Числовой идентификатор валюты счета корреспондента(например 980)
240  [15 ] Код ОКПО корреспондента(из-за России)
255  [149] Наименование корреспондента(например ДЕМО КЛИЕНТ)
404  [ 3 ] Числовой идентификатор страны корреспондента(например 804)
407  [ 1 ] Д/К(1-списание со счета клиента,0-зачисление на счёт клиента)
408  [ 3 ] Вид обработки (1-ПЛАТЕЖНОЕ ПОРУЧЕНИЕ,2-ТРЕБОВАНИЕ ПОРУЧЕНИЕ)
411  [14 ] Сумма документа(больше 0)
425  [10 ] Номер документа(не пустой)
435  [ 4 ] процент НДС в сотых 2000=20.00
439  [ 1 ] проставлять НДС в документе(0-нет,1-Без ПДВ,2-в т.ч ПДВ)
440  [ 1 ] Признак документа(0-обычный,1-в счёт неотл.нужд,2-в карт2)
441  [ 1 ] Вид платежа(0-обычный,2-экспорт-импорт)
442  [ 4 ] Код раздела платежа
446  [ 4 ] Код параграфа платежа
450  [ 8 ] Дата документа(в формате ДДММГГГГ)
458  [ 8 ] Дата валютирования документа(в формате ДДММГГГГ)
466  [159] Назначение платежа(длина больше 3 символов)
625  [15 ] МФО(BIC) банка посредника
640  [149] Наименование банка посредника(если есть МФО можно пробелы)
789  [ 1 ] За счёт кого комисии(0-Ваши,1-Корр,2-Обеих)
790  [18 ] Код платежа(можно заполнить пробелами)
808  [35 ] Банк посредника в клиринговой системе(можно пробелы)значение
843  [ 1 ] Счет или банк получателя в клиринговой системе(0/1) признак
844  [35 ] Счет или банк получателя в клиринговой системе(можно пробелы)значение
879  [ 1 ] Способ оповещения бенефициара любым/по наиболее эфект/по телефону(0/1/2)
880  [191] Сообщение бенефициару(можно пробелы)
1071 [35 ] Счет клиента для списания комисий
1106 [ 3 ] Числовой идентификатор валюты счета клиента для списания комисий
1109 [119] Резерв(можно заполнить пробелами)
1228 [50 ] Сообщение об ошибке приема(заполняется программой приема)
1278 [ 2 ] \r\n перевод строки

 Длина текстовой строки 1280 байта.
*/
fprintf(ff,"%-35.35s",rec.nsh.ravno()); /*Счет клиента(с учетом доступа к счетам на рабочем месте)*/
fprintf(ff,"%-3.3s","980"); /*Числовой идентификатор валюты счета клиента (например 980)*/
fprintf(ff,"%-15.15s",rec.mfo1.ravno()); /*МФО(BIC) банка корреспондента (например 300012)*/
fprintf(ff,"%-*.*s",iceb_u_kolbait(149,rec.naiban1.ravno()),iceb_u_kolbait(149,rec.naiban1.ravno()),rec.naiban1.ravno()); /*Наименование банка корреспондента(если есть МФО можно пробелы)*/
fprintf(ff,"%-35.35s",rec.nsh1.ravno());  /*Счет корреспондента*/
fprintf(ff,"%-3.3s","980");  /*Числовой идентификатор валюты счета корреспондента (например 980)*/
fprintf(ff,"%-15.15s",rec.kod1.ravno()); /*Код ОКПО корреспондента (можно пробелы)*/
fprintf(ff,"%-*.*s",iceb_u_kolbait(149,rec.naior1.ravno()),iceb_u_kolbait(149,rec.naior1.ravno()),rec.naior1.ravno()); /*Наименование корреспондента (например ДЕМО КЛИЕНТ)*/
fprintf(ff,"%-3.3s","804"); /*Числовой идентификатор страны корреспондента (например 804)*/
                                             
if(iceb_u_SRAV(tabl,"Pltp",0) == 0)
 fprintf(ff,"%-1.1s","1");                   
if(iceb_u_SRAV(tabl,"Pltt",0) == 0)
 fprintf(ff,"%-1.1s","0");                   
                                             
if(iceb_u_SRAV(tabl,"Pltp",0) == 0)
  fprintf(ff,"%-3.3s","1");                  
if(iceb_u_SRAV(tabl,"Pltt",0) == 0) /*Вид обработки (1-ПЛАТЕЖНОЕ ПОРУЧЕНИЕ, 2-ТРЕБОВАНИЕ ПОРУЧЕНИЕ)*/
  fprintf(ff,"%-3.3s","2");                  
                                             
fprintf(ff,"%-14.f",bb);      /*Сумма документа (больше 0)*/
fprintf(ff,"%-10s",rec.nomdk.ravno());  /*Номер документа (не пустой)*/
fprintf(ff,"%-4.4s","20000"); /*процент НДС в сотых 2000=20.00*/
fprintf(ff,"%-1.1s","0");     /*проставлять НДС в документе (0-нет,1-Без ПДВ,2-в т.ч ПДВ)*/
vidp=0;
/***************
if(rec.vidpl[0] == 'В' || rec.vidpl[0] == 'в' || rec.vidpl[0] == 'B' || rec.vidpl[0] == 'b')
  vidp=1;
if(rec.vidpl[0] == 'К' || rec.vidpl[0] == 'к' || rec.vidpl[0] == 'k' || rec.vidpl[0] == 'K')
  vidp=2;
*****************/
fprintf(ff,"%d",vidp);     /*Признак документа(0-обычный,1-в счёт неотл.нужд,2-в карт2)*/

fprintf(ff,"%d",0);     /*Вид платежа (0-обычный,1-в бюджет,2-экспорт-импорт)*/
fprintf(ff,"%-4.4s"," ");     /*Код раздела по бюджетам*/
fprintf(ff,"%-4.4s"," ");     /*Код параграфа по бюджетам*/
//fprintf(ff,"%-4.4s"," ");     /*Код вида по бюджетам*/
fprintf(ff,"%02d%02d%04d",rec.dd,rec.md,rec.gd);/*Дата документа (в формате ДДММГГГГ)*/
//if(rec.gv == 0)
  fprintf(ff,"%02d%02d%04d",rec.dd,rec.md,rec.gd);/*Дата валютирования документа (в формате ДДММГГГГ)*/
//else
//  fprintf(ff,"%02d%02d%04d",rec.dv,rec.mv,rec.gv);/*Дата валютирования документа (в формате ДДММГГГГ)*/
fprintf(ff,"%-*.*s",iceb_u_kolbait(159,koment.ravno()),iceb_u_kolbait(159,koment.ravno()),koment.ravno());  /*Назначение платежа (длина больше 3 символов)*/
fprintf(ff,"%-15.15s"," ");    /*МФО(BIC) банка транзита*/
fprintf(ff,"%-149.149s"," ");  /*Наименование банка транзита (если есть МФО можно пробелы)*/
fprintf(ff,"%-1.1s"," ");      /*За счёт кого комисии (0-Ваши,1-Корр,2-Обеих)*/
fprintf(ff,"%-18.18s"," ");    /*Код платежа (можно заполнить пробелами)*/
fprintf(ff,"%-35.35s"," "); /*[35 ] Банк посредника в клиринговой системе(можно пробелы)значение*/
fprintf(ff,"%-1.1s","0");   /*[ 1 ] Счет или банк получателя в клиринговой системе(0/1) признак*/
fprintf(ff,"%-35.35s"," "); /*[35 ] Счет или банк получателя в клиринговой системе(можно пробелы)значение*/
fprintf(ff,"%-1.1s","0");   /*[ 1 ] Способ оповещения бенефициара любым/по наиболее эфект/по телефону(0/1/2)*/
fprintf(ff,"%-191.191s"," ");/* [191] Сообщение бенефициару(можно пробелы)*/
fprintf(ff,"%-35.35s"," ");  /*[35 ] Счет клиента для списания комисий*/
fprintf(ff,"%-3.3s"," ");    /*[ 3 ] Числовой идентификатор валюты счета клиента для списания комисий*/
fprintf(ff,"%-119.119s"," ");  /*Резерв (можно заполнить пробелами)*/
fprintf(ff,"%-50.50s\r\n"," ");  /*Сообщение об ошибке приема (заполняется программой приема)*/
                               /*\r\n перевод строки*/
}
fclose(ff);
iceb_perecod(1,imaf,wpredok);
return(0);
}
