/*$Id: b_b2_bank_on_linew.c,v 1.13 2014/02/28 05:20:58 sasa Exp $*/
/*16.10.2019	04.05.2006	Белых А.И.	b2_bank_on_linew.c
 Формат файлов импорта и экспорта соответствует формату информационных строк
 файлов А/В СЭП НБУ. Файл является текстовым. Каждая строка содержит информацию об одном документе
 Строки завершаются последовательностью CR-LF (ASCII - символы 13 и 10).
Каждая строка имеет фиксированную строуктуру данных и может принимать
следующие значения:
C -поле содержит строковое значение, выровненное влуво
N -поле содержит целое число без ведущих нолей, выровненное вправо
с - поле содержит целое число, выровненное вправо, может содержать лидирующие ноли
D - поле содержит дату в формате YYMMDD (две цифры года, месяца и дня соответственно
Т - поле содержит время в формате HHMMSS (две цифры часа, от 1 до 24, минуты и секунды соответственно)

Некоторые поля, используемые в файлах А/В, не имеют значения для "Клиент-банка".
Эти поля обозначены прочерком в таблице, их следует оставлять пустыми при формировании файла импорма и игнорировать
в файлах электронной выписки.

Подпрограмма для экспорта платёжки в подсистему Б2 bank On Line
-----------------------------------------------------------------------
N  Наименование поля                      Тип данных Позиции Количество знаков
-----------------------------------------------------------------------
1  МФО банка плательщика                       N     1-9        9           
2  Номер счёта плательщика                     N     10-23      14 изменил на 29
3  МФО получателя                              N     24-32      9           
4  Номер счёта получателя                      N     33-46      14 изменил на 29
5  Тип финансовой операции                     С     47-47      1           
6  Сумма в копейках                            N     48-63      16          
7  Вид платежа                                 N     64-65      2           
8  Номер документа                             С     66-75      10          
9  Код валюты                                  N     76-78      3           
10 Дата документа                              D     79-84      6           
11 Дата получения документа в банке            D     85-90      6           
12 Наименование плательщика                    С     91-128     38          
13 Наименование получателя                     С     129-166    38          
14 Назначение платежа                          С     167-326    160
15 Дополнительные реквизиты                    С     327-386    60          
16 Код назначения платежа                      С     387-389    3           
17 -                                           С     390-391    2           
18 Идентификационный код плательщика (ОКПО)    С     392-405    14          
19 Идентификационный код получателя (ОКПО)     С     406-419    14          
20 Уникальный номер документа                  N     420-428    9           
21 -                                           С     429-434    6           
22 -                                           N     435-436    2           
23 -                                           C     437-444    8           
24 -                                           C     445-508    64          
25 -                                           C     509-520    12          
26 -                                           N     521-526    6           
27 -                                           Т     527-530    4           
28 -                                           Т     531-534    4           
29 -                                           С     535-546    12          
30 -                                           N     547-552    6           
31 -                                           Т     553-556    4           
32 -                                           Т     557-560    4           
33 -                                           С     561-572    12          
34 -                                           N     573-578    6           
35 -                                           Т     579-582    4           
36 -                                           Т     583-586    4           
37 -                                           D     587-592    6           
38 CRLF                                        C     593-594    2           

5 - 1 - Обычный платёж
    2 - информационный кредитовый документ (т.е. требование к получателю уплатить указанную сумму);
    3 - информационный дебетовый документ (т.е. уведомление получателя об уплате суммы).
    
7 - 1 - платёжное поручение
    6 - мемориальный ордер

11 - В файле импорта следует оставлять пустым. В файле электронной выписки указывает дату
     поступления документа в банк плательщика
15 - В этом поле указывается код страны плательщика/получателя, если плательщик/получатель является не резидентом, 
     в следующем формате:#nП764О018#, ("П" и "О" - русские заглавные символы),
     где "764" код страны плательщика, "018" - код страны получателя.
16 - Следует указывать код 070 для платежей в бюджет и оставлять поле пустым для прочих платежей
20 - В файле импорта может оставаться пустым. В файле электронной выписки содержит уникальный номер,
     присвоенный данному документа в банке.
          
*****************************/
#include        <errno.h>
#include <math.h>
#include "buhg_g.h"
#include        "dok4w.h"

extern class REC rec;
extern SQL_baza bd;

int b_b2_bank_on_linew(const char *tabl,GtkWidget *wpredok)
{

char		imaf1[64];
FILE		*ff1;
class iceb_u_str koment("");
char		strsql[512];
short		d,m,g;


int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql,wpredok);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_menu_soob(gettext("Не найдено ни одного документа для передачи в банк!"),wpredok);
  return(1);
 }


sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  iceb_er_op_fil(imaf1,"",errno,wpredok);
  return(1);
 }
char doprek[128];
memset(doprek,'\0',sizeof(doprek));

int suma_int=0;
double suma_double=0.;
double bb=0.;
while(cur.read_cursor(&row) != 0)
 {
  iceb_u_rsdat(&d,&m,&g,row[0],2);

  if(readpdokw(tabl,g,row[1],wpredok) != 0)
     continue;


  /*Читаем комментарий*/
  readkomw(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment,wpredok);


  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_u_okrug(rec.sumd,0.01);

  bb=rec.sumd*100.;
 
  modf(bb,&suma_double);
  suma_int=(int)suma_double;

  memset(doprek,'\0',sizeof(doprek));
  if(rec.kodnr.getdlinna() > 1)
   sprintf(doprek,"nП764О%s",rec.kodnr.ravno());
     
  fprintf(ff1,"\
%9.9s\
%29.29s\
%9.9s\
%29.29s\
%1.1s\
%16.16d\
%2.2s\
%-10.10s\
%3.3s\
%02d%02d%02d\
%6.6s\
%-*.*s\
%-*.*s\
%-*.*s\
%-60.60s\
%-3.3s\
%-2.2s\
%-14.14s\
%-14.14s\
%9.9s\
%164.164s\r\n",
  rec.mfo.ravno(),
  rec.nsh.ravno(),
  rec.mfo1.ravno(),
  rec.nsh1.ravno(),
  "1",
  suma_int,
  "1",
  rec.nomdk.ravno(),
  "980",
  rec.gd-2000,rec.md,rec.dd,
  "",
  iceb_u_kolbait(38,rec.naior.ravno()),iceb_u_kolbait(38,rec.naior.ravno()),rec.naior.ravno(),
  iceb_u_kolbait(38,rec.naior1.ravno()),iceb_u_kolbait(38,rec.naior1.ravno()),rec.naior1.ravno(),
  iceb_u_kolbait(160,koment.ravno()),iceb_u_kolbait(160,koment.ravno()),koment.ravno(),
  doprek,
  "",
  "",
  rec.kod.ravno(),
  rec.kod1.ravno(),
  "",
  "");
       

 }

fclose(ff1);
iceb_perecod(2,imaf1,wpredok);
return(0);

}
