/*$Id:$*/
/*30.01.2024	18.01.2022	Белых А.И.	iceb_tu_double.cpp
массив чисел двойной точности
*/

#include "util.h"


/****************************/
/*Конструктор объекта       */
/****************************/
iceb_tu_double::iceb_tu_double(int razmer) //размер массива
{
kolz=0;
masiv_double=NULL;

if(razmer == 0)
 return;
 
kolz=razmer;
if((masiv_double=(double *)calloc(razmer,sizeof(double))) == NULL)
 {
  printf("\n%s-Не могу выделить память для masiv_double !!!\n",__FUNCTION__);
//  return(1);
 }

}

/****************************/
/*Конструктор объекта без параметров*/
/****************************/
iceb_tu_double::iceb_tu_double()
{
kolz=0;
optimiz=0;
masiv_double=NULL;
}
/****************************/
/*Деструктор класса*/
/****************************/
iceb_tu_double::~iceb_tu_double()
{
 iceb_tu_double::free_class();
}
/******************************/
/*Вернуть количество элементов*/
/*******************************/
int iceb_tu_double::kolih()
{
return(kolz);
}
/*************************************************/
/*Записать значение в добавленную ячейку массива*/
/*************************************************/

int iceb_tu_double::plus(double znah) //Значение 
{
return(plus(znah,-1));
}
/********************************************************************/
/*проверить есть ли не нулевые значения в колоке двумерного массива*/
/*Если вернули 0 - значит все значения нулевые 1-есть не нулевое значение -1-массив меньше чем заданно в параметрах -2-номер колонки больше чем максимальное количество колонок*/
/********************************************************************/
int iceb_tu_double::prov_kol(int kol_str, /*Количество строк в двумерном массиве*/
int kol_kol, /*Количество колонок в массиве*/
int nom_kol) /*Номер колонки которую нужно проверить*/
{
if(kolz < kol_str*kol_kol)
 return(-1);
if(nom_kol >= kol_kol)
 return(-2);
 
for(int nom=0; nom < kol_str; nom++)
 {
  if(masiv_double[nom*kol_kol+nom_kol] != 0.)
   return(1);
 }
return(0);
}

/********************************************************************/
/*проверить есть ли не нулевые значения в строке двумерного массива*/
/*Если вернули 0 - значит все значения нулевые 1-есть хотябы одно не нулевое значение -1-ошибка в размере массива -2-номер строки больше чем максимальное количество строк*/
/********************************************************************/
int iceb_tu_double::prov_str(int kol_str, /*Количество строк в двумерном массиве*/
int kol_kol, /*Количество колонок в массиве*/
int nom_str) /*Номер строки которую нужно проверить*/
{
if(kolz < kol_str*kol_kol)
 return(-1);
if(nom_str >= kol_str)
 return(-2);
 
for(int nom=0; nom < kol_kol; nom++)
 {
  if(masiv_double[nom_str*kol_kol+nom] != 0.)
   return(1);
 }
return(0);
}
/************************************************/
/*получить сумму по колонке двухмерного массива*/
/************************************************/
double iceb_tu_double::suma_kol(int kol_str, /*Количество строк в двумерном массиве*/
int kol_kol, /*Количество колонок в массиве*/
int nom_kol) /*Номер колонки которую нужно проверить*/
{
double suma=0.;
if(kolz < kol_str*kol_kol)
 return(0.);
for(int nom=0; nom < kol_str; nom++)
  suma+=masiv_double[nom*kol_kol+nom_kol];
return(suma);
}

/*************************************************/
/*Увеличить размер массива на заданное количество елементов*/
/*************************************************/

int iceb_tu_double::plus_str(int znah) //Значение 
{
if((masiv_double=(double *)realloc(masiv_double,(kolz+znah)*sizeof(double))) == NULL)
 {
  printf("\n%s-Не могу добавить память для masiv_double double !!!\n",__FUNCTION__);
  return(-1);
 }  

for(int ii=kolz; ii < kolz+znah; ii++)
  masiv_double[ii]=0.;
kolz+=znah;

return(0);
}  
/******************************************************/
/*Добавить значение в масив  просумировав его с предыдущим значением и если нужно с увеличением его размера*/
/*******************************************************/

int iceb_tu_double::plus(double znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{
/*
printf("iceb_tu_double::add_masiv_double znah=%f zapis=%d kol=%d kolz=%d\n",
znah,zapis,kol,kolz);
*/
if(zapis == -1)
 {
  if(kolz == 0)
   {
    if((masiv_double=(double *)calloc(1,sizeof(double))) == NULL)
     {
      printf("\n%s-Не могу выделить память для masiv_double double !!!\n",__FUNCTION__);
      return(-1);
     }
    kolz=1;
   }
  else
   {
    kolz++;
    if((masiv_double=(double *)realloc(masiv_double,kolz*sizeof(double))) == NULL)
     {
      printf("\n%s-Не могу добавить память для masiv_double double !!!\n",__FUNCTION__);
      return(-1);
     }  
   }
  masiv_double[kolz-1]=znah;
 }
else
 {
  if(zapis >= kolz)
   {
    printf("\n%s-Запрошенный елемент больше размера массива zapis=%d >= kolz=%d\n",__FUNCTION__,zapis,kolz);
    return(-1);
   }
  masiv_double[zapis]+=znah;
 } 
return(0);

}

/******************************************************/
/*Добавить значение в масив не просумировав его с предыдущим значением и если нужно с увеличением его размера*/
/*******************************************************/

int iceb_tu_double::new_plus(double znah, //Значение 
int zapis) //-1 в следующюю ячейку иначе в указанную
{
/*
printf("iceb_tu_double::add_masiv_double znah=%f zapis=%d kol=%d kolz=%d\n",
znah,zapis,kol,kolz);
*/
if(zapis == -1)
 {
  if(kolz == 0)
   {
    if((masiv_double=(double *)calloc(1,sizeof(double))) == NULL)
     {
      printf("\n%s-Не могу выделить память для masiv_double double !!!\n",__FUNCTION__);
      return(-1);
     }
    kolz=1;
   }
  else
   {
    kolz++;
    if((masiv_double=(double *)realloc(masiv_double,kolz*sizeof(double))) == NULL)
     {
      printf("\n%s-Не могу добавить память для masiv_double double !!!\n",__FUNCTION__);
      return(-1);
     }  
   }
  masiv_double[kolz-1]=znah;
 }
else
 {
  if(zapis >= kolz)
   {
    printf("\n%s-Запрошенный елемент больше размера массива zapis=%d >= kolz=%d\n",__FUNCTION__,zapis,kolz);
    return(-1);
   }
  masiv_double[zapis]=znah;
 } 
return(0);

}
/*********************/
/*Уничтожение массива*/
/**********************/
void iceb_tu_double::free_class()
{
kolz=0;
if(masiv_double != NULL)
 {
  free(masiv_double);
  masiv_double=NULL;
 }
}

/*****************************************************/
/*Найти в каком елементе массива находится значение*/
/*****************************************************/
int iceb_tu_double::find(double znah)
{

for(int i=0; i < kolz; i++)
 if(znah == masiv_double[i])
  return(i);
return(-1);

}
/*****************************************************/
/*Найти в каком елементе массива находится значение*/
/*****************************************************/
int iceb_tu_double::find(const char *znah)
{
 return(find(atof(znah)));
}
/*****************************************************/
/*Вернуть значение нужного елемента массива*/
/*****************************************************/
double iceb_tu_double::ravno(int elem)
{
if(elem > kolz)
 {
  printf("\n%s-Запрошенный елемент больше размера массива elem=%d > kolz=%d\n",__FUNCTION__,elem,kolz);
  return(0.);
 }
return(masiv_double[elem]);

}
/************************************/
/* Создать массив*/
/************************************/
int iceb_tu_double::make_class(int razmer) //Размер массива
{
if(razmer == 0)
 return(0);
 
kolz=razmer;
if((masiv_double=(double *)calloc(razmer,sizeof(double))) == NULL)
 {
  printf("\n%s-Не могу выделить память для masiv_double double !!!\n",__FUNCTION__);
  return(1);
 }
return(0);
}
/*****************************/
/*Распечатать массив*/
/****************************/
void iceb_tu_double::print_class()
{
printf("%s: kolz=%d\n",__FUNCTION__,kolz);
for(int i=0; i < kolz; i++)
  printf("%f\n",masiv_double[i]);
}
/******************/
/*Очистить массив*/
/******************/
void iceb_tu_double::clear_class()
{
for(int i=0; i < kolz;i++)
  masiv_double[i]=0.;
}

/**************************************/
/*Вернуть сумму всех элементов массива*/
/**************************************/
double iceb_tu_double::suma(void)
{
double suma=0.;
for(int i=0; i < kolz; i++)
  suma+=masiv_double[i];
return(suma);
}
