/*$Id: icebstart_rf.c,v 5.8 2013/05/17 14:56:29 sasa Exp $*/
/*27.02.2017	07.09.2007	Белых А.И.	icebstart_rf.c
Чтение и выполнение запросов к базе данных сразу после открытия базы
*/
#include "buhl.h"
extern class iceb_tu_str kodirovka_iceb;

void icebstart_rf()
{
char stroka[1024];

if(kodirovka_iceb.getdlinna() > 1)
 {
  sprintf(stroka,"SET NAMES %s",kodirovka_iceb.ravno_udsimv("-"));
  iceb_t_sql_zapis(stroka,1,0);
 }




/*********************************
SQL Modes

SQL modes – это настройка поведения работы сервера MySQL, состоящая из режимов, 
каждый из которых контролирует какой-либо один аспект обработки запроса.

Возможности SQL mode:
1. Устанавливает строгую или мягкую проверку входных данных
2. Включает или отключает следование SQL стандарту
3. Обеспечивает лучшую синтаксическую совместимость с другими БД
По сути, SQL mode очень мощный механизм тюнинга БД, позволяющий гибко манипулировать обработкой запросов и уведомлениями MySQL.

Прежде чем мы перейдём к последующей теории, вы должны строго-настрого уяснить, 
что изменение режима SQL mode после создания и вставки данных в партиционные таблицы 
(partitioning tables) может привести к существенным изменениям в поведении таких таблиц, 
что, в свою очередь, может привести к потере или повреждению данных. Настоятельно рекомендуется, 
чтобы вы никогда не изменяли SQL режим после создания партиционных таблиц.
При репликации партиционных таблиц, отличающиеся параметры SQL mode на Primary и 
Slave MySQL серверах также может привести к проблемам. Для стабильной работы 
репликации между серверами, настройки SQL mode должны быть идентичными.

Теперь, после того, как вы осознали всю ответственность в использовании SQL режимов, 
перейдём к его сути.

Контроль текущего SQL режима происходит через системную переменную sql_mode. 
Для задания значения используется команда SET. Ниже представлены возможные варианты установки данного режима.

1. Соответствует значению по умолчанию для только что установленной БД (никаких специальных режимов не установлено). 
Кавычки являются обязательными.

SET sql_mode = '';

Установка одного режима sql_mode. Возможно два варианта – с кавычками и без них.

SET sql_mode = ANSI_QUOTES;
SET sql_mode = 'TRADITIONAL';

3. Установка нескольких режимов sql_mode. Указание кавычек является обязательным!

SET sql_mode = 'IGNORE_SPACE,ANSI_QUOTES';
SET sql_mode = 'STRICT_ALL_TABLES,ERROR_FOR_DIVIZION_BY_ZERO'


Несмотря на то, что названия режимов регистронезависимые, я для удобства прочтения буду везде в статье писать их в верхнем регистре.

В примерах выше мы устанавливали режимы для текущей сессии, но если вы обладаете привилегиями суперпользователя, то можно задать глобальный режим для всего сервера и всех текущих коннектов, указав параметр GLOBAL. Полный синтаксис установки sql_mode выглядит так:

SET [GLOBAL|SESSION] sql_mode='параметры';

Для просмотра текущих значений глобального и сессионного режима сервера используйте следующие запросы:

SELECT @@global.sql_mode;
SELECT @@session.sql_mode;

Помимо команды SET существует ещё два способа задания режима работы БД:
1. Запустить сервер с опцией --sql-mode="<режимы>"
2. Установить в файле my.cnf (для unix подобных систем) или my.ini (для windows) параметр 
sql-mode="<режимы>"

**********************/


iceb_t_sql_zapis("SET SESSION sql_mode = ''",1,0);

}