/*$ld:$*/
/*12.01.2022	01.12.2021	Белых А.И.	xuslpsnds.cpp
Распределение НДС по полученным услугам
*/
#include        "buhg.h"
class xuslpsnds_rk
 {
  public:

   class iceb_tu_str datan;
   class iceb_tu_str datak;
   class iceb_tu_str podr;
   class iceb_tu_str kodop;
   class iceb_tu_str kodgr;
   class iceb_tu_str kodusl;
   class iceb_tu_str shetu;
   
   xuslpsnds_rk()
    {
     clear();
    }  
   void clear()
    {
     datan.new_plus("");
     datak.new_plus("");
     podr.new_plus("");
     kodop.new_plus("");
     kodgr.new_plus("");
     kodusl.new_plus("");
     shetu.new_plus("");
    }
   
 };


void xuslpsnds_rrp(class xuslpsnds_rk *rk,FILE *ff);
void xuslpsnds_hap(class iceb_rnl_c *rd,int *kolstr,FILE *ff);
void xuslpsnds_hap_dok(class iceb_rnl_c *rh,int *kolstr,FILE *ff);



int xuslpsnds(class spis_oth *oth)
{
static class xuslpsnds_rk rk;
int kom=0,kom1=0;
int kgr=0,kodusl=0;

VVOD MENU(3);
VVOD VV(0);
VV.VVOD_spisok_add_ZAG(gettext("Распределение НДС по полученным услугам"));

VV.VVOD_spisok_add_data(rk.datan.ravno(),11);
VV.VVOD_spisok_add_data(rk.datak.ravno(),11);
VV.VVOD_spisok_add_data(rk.podr.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodop.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodgr.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodusl.ravno(),128);
VV.VVOD_spisok_add_data(rk.shetu.ravno(),128);


VV.VVOD_spisok_add_MD(gettext("Дата начала..............")); //0
VV.VVOD_spisok_add_MD(gettext("Дата конца...............")); //1
VV.VVOD_spisok_add_MD(gettext("Код подразделения...(,,).")); //2
VV.VVOD_spisok_add_MD(gettext("Код операции........(,,).")); //3
VV.VVOD_spisok_add_MD(gettext("Код группы услуги...(,,).")); //4
VV.VVOD_spisok_add_MD(gettext("Код услуги..........(,,).")); //5
VV.VVOD_spisok_add_MD(gettext("Счёт учета..........(,,).")); //6


naz:;
clear();

helstr(LINES-1,0,
//"F1",gettext("помощь"),
"F2/+",gettext("поиск"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

kom=VV.vvod(0,1,1,-1,-1);

rk.datan.new_plus(VV.data_ravno(0));
rk.datak.new_plus(VV.data_ravno(1));
rk.podr.new_plus(VV.data_ravno(2));
rk.kodop.new_plus(VV.data_ravno(3));
rk.kodgr.new_plus(VV.data_ravno(4));
rk.kodusl.new_plus(VV.data_ravno(5));
rk.shetu.new_plus(VV.data_ravno(6));


class iceb_tu_str kods("");
class iceb_tu_str naims("");

switch (kom)
 {
  case ESC:
  case FK10:
     return(1);
     break;

  case FK1:
    GDITE();
//    iceb_t_pdoc("matu5_10.txt");
    clear();
    goto naz;

  case PLU:
  case FK2:
  case FK5:
     break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка подразделений"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка групп"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка операций приходов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка услуг"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка счетов"));
    MENU.VVOD_spisok_add_MD(gettext("Выход"));

    clearstr(LINES-1,0);
    
    kom1=0;
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 5 :
      case -1:
       goto naz;

      case 0 :
        if(dirpodrusl(1,&rk.podr,&naims) == 0)
         VV.data_z_plus(2,rk.podr.ravno());
        goto naz;


      case 1 :
        vibrek("Uslgrup",&rk.kodgr,&naims);
        VV.VVOD_spisok_zapis_data(4,rk.kodgr.ravno());
        goto naz;

      case 2 :
        if(diruslop1(1,&rk.kodop,&naims) == 0)
          VV.data_z_plus(3,rk.kodop.ravno());
        goto naz;

      case 3 :
        if(dirusl(&kgr,&kodusl,&naims,1,"") == 0)
         {
          VV.data_z_plus(5,kodusl);
         }
        goto naz;

      case 4 :
        vibrek("Plansh",&rk.shetu,&naims);
        VV.VVOD_spisok_zapis_data(6,rk.shetu.ravno());
        goto naz;
               
     }
    goto naz;

  case FK4:
    VV.VVOD_clear_data();    
    goto naz;

  default:
    goto naz;
 }
short dn=0,mn=0,gn=0;
short dk=0,mk=0,gk=0;

if(iceb_t_rsdat(&dn,&mn,&gn,rk.datan.ravno(),&dk,&mk,&gk,rk.datak.ravno()) != 0)
 goto naz;

time_t tmm=0;
time(&tmm);

char strsql[1024];
int kolstr=0;
class SQLCURSOR cur;
class SQLCURSOR cur1;
SQL_str row,row1;
int kolstr1=0;

class iceb_tu_spisok all_nds;
class iceb_tu_spisok kodusl_pnds;
class iceb_tu_double suma_kodusl_pnds=0;
double suma=0.;
class iceb_tu_str naim_usl("");
class iceb_tu_str grupa("");
class iceb_tu_str shet_uusl("");


sprintf(strsql,"select * from Usldokum2 where datd >= '%04d-%02d-%02d' and datd <= '%04d-%02d-%02d' \
and tp=1 and metka=1",gn,mn,dn,gk,mk,dk);


if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

class iceb_fopen fil;
char imaf_dok[64];
sprintf(imaf_dok,"unds%d.lst",getpid());
if(fil.start(imaf_dok,"w") != 0)
 return(1);

iceb_t_zagolov(gettext("Протокол хода расчёта по распределению НДС по услугам"),dn,mn,gn,dk,mk,gk,fil.ff);

xuslpsnds_rrp(&rk,fil.ff);

class iceb_rnl_c rh_dok;
xuslpsnds_hap_dok(&rh_dok,NULL,fil.ff);
class iceb_tu_str nds("");

while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);

  if(iceb_tu_proverka(rk.podr.ravno(),row[10],0,0) != 0)
   continue;


  int kodusl=atoi(row[5]);
  shet_uusl.new_plus(row[9]);
      
  if(iceb_tu_proverka(rk.kodusl.ravno(),kodusl,0,0) != 0)
   continue;

  if(iceb_tu_proverka(rk.shetu.ravno(),shet_uusl.ravno(),1,0) != 0)
     continue;              

  sprintf(strsql,"select kodop,nds,pn from Usldokum where datd='%s' and podr=%s and nomd='%s' and tp=1",
  row[1],row[10],row[3]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) != 1)
   {
    printw("\n%s\n",gettext("Не найдена шапка документа!"));
    OSTANOV();
    continue;
   }

  if(iceb_tu_proverka(rk.kodop.ravno(),row1[0],0,0) != 0)
    continue;

  int metka_nds=atof(row1[1]);
  
  switch(metka_nds)
   {
    case 0:  
     nds.new_plus(row1[2]);
     break;

    case 1:  
     nds.new_plus("0-1");
     break;
    case 2:  
     nds.new_plus("0-2");
     break;
    case 3:  
     nds.new_plus("0-3");
     break;

    case 4:  
     nds.new_plus("7");
     break;     

    case 5:  
     nds.new_plus("14");
     break;     
    default:
     nds.new_plus("не определён");
     break;
   }

  /*узнаём наименование услуги*/
  sprintf(strsql,"select kodgr,naius from Uslugi where kodus=%d",kodusl);

  if(iceb_t_sql_readkey(strsql,&row1,&cur1) > 0)
   {
    grupa.new_plus(row1[0]);
    naim_usl.new_plus(row1[1]);
   }
  else 
   {
    grupa.new_plus("");
    naim_usl.new_plus("");   
   }

  if(rk.kodgr.getdlinna() > 1)
   {
    if(iceb_tu_proverka(rk.kodgr.ravno(),grupa.ravno(),0,0) != 0)
     continue;    
   }
  
  printw("%s|%-5s|%-10s|%-8d|%-*.*s|%10.10g|%10.10g|%10.2f|%3.3g|\n",
  iceb_tu_datzap(row[1]),row[10],row[3],kodusl,
  iceb_tu_kolbait(30,naim_usl.ravno()),
  iceb_tu_kolbait(30,naim_usl.ravno()),
  naim_usl.ravno(),  
  atof(row[6]),atof(row[7]),suma,nds.ravno_atof());

#if 0
fprintf(ff,"\
Дата докум|Подр.|Номер док.|Код усл.|   Наименование услуги        |Количество|   Цена   |  Сумма   |НДС|\n");
/***********
1234567890|12345|1234567890|12345678|123456789012345678901234567890|1234567890|1234567890|1234567890|123|
**************/
#endif    
  suma=atof(row[6])*atof(row[7]);
    

  fprintf(fil.ff,"%s|%-5s|%-10s|%-8d|%-*.*s|%10.10g|%10.10g|%10.2f|%3.3g|\n",
  iceb_tu_datzap(row[1]),row[10],row[3],kodusl,
  iceb_tu_kolbait(30,naim_usl.ravno()),
  iceb_tu_kolbait(30,naim_usl.ravno()),
  naim_usl.ravno(),  
  atof(row[6]),atof(row[7]),suma,nds.ravno_atof());
  

  if(all_nds.find(nds.ravno()) < 0)
   all_nds.plus(nds.ravno());

  sprintf(strsql,"%d|%s",kodusl,nds.ravno());
  if((kom=kodusl_pnds.find(strsql)) >= 0)  
   {
    suma_kodusl_pnds.plus(suma,kom);
   }
  else
   {
    kodusl_pnds.plus(strsql);
    suma_kodusl_pnds.plus(suma);
   }
 }

fprintf(fil.ff,"ICEB_LST_END\n");
fprintf(fil.ff,"\
---------------------------------------------------------------------------------------------------------\n");

iceb_t_podpis(fil.ff);
fil.end();



char imaf[64];
sprintf(imaf,"undss%d.lst",getpid());
if(fil.start(imaf,"w") != 0)
 return(1);
iceb_t_zagolov(gettext("Распределение НДС по полученным услугам"),dn,mn,gn,dk,mk,gk,fil.ff);
xuslpsnds_rrp(&rk,fil.ff);

class iceb_rnl_c rh;

class iceb_tu_str liniq("------------------------------------------------");
class iceb_tu_str liniqw("------------");

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  liniq.plus("-----------");
  liniqw.plus("-----------");
 }

/*формируем шапку распечатки*/
rh.hapka.new_plus(liniq.ravno());
rh.hapka.plus("\n");
printw("%s\n",liniqw.ravno());

printw("           |");

rh.hapka.plus(gettext("Код у.|        Наименование усуги              |"));
/*******
                       123456|1234567890123456789012345678901234567890|
***********/

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  sprintf(strsql,"%10s|",all_nds.ravno(nom));
  rh.hapka.plus(strsql);
  printw("%s",strsql);
 }

sprintf(strsql,"\n%s\n",liniq.ravno());
rh.hapka.plus(strsql);
printw("\n%s\n",liniqw.ravno());

xuslpsnds_hap(&rh,NULL,fil.ff);


double itogo[all_nds.kolih()];
double itogo_snds[all_nds.kolih()];

for(int nom=0; nom < all_nds.kolih();nom++)
 itogo[nom]=0.;
 
for(int nom=0; nom < kodusl_pnds.kolih(); nom++)
 {

  iceb_tu_polen(kodusl_pnds.ravno(nom),&kodusl,1,'|');
  iceb_tu_polen(kodusl_pnds.ravno(nom),&nds,2,'|');
  
  int nom_nds=all_nds.find(nds.ravno());
  double nom_suma=suma_kodusl_pnds.ravno(nom);
      
  itogo[nom_nds]+=nom_suma;
  
  /*узнаём наименование материала*/
  sprintf(strsql,"select naius from Uslugi where kodus=%d",kodusl);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) > 0)
   naim_usl.new_plus(row1[0]);
  else 
   naim_usl.new_plus("");   

  fprintf(fil.ff,"%6d|%-*.*s|",
  kodusl,
  iceb_tu_kolbait(40,naim_usl.ravno()),
  iceb_tu_kolbait(40,naim_usl.ravno()),
  naim_usl.ravno());
    
  for(int shetchik_nds=0; shetchik_nds < all_nds.kolih(); shetchik_nds++)
   {
    
    if(nom_nds == shetchik_nds)
     fprintf(fil.ff,"%10.2f|",nom_suma);
    else
     fprintf(fil.ff,"          |");
   }
  fprintf(fil.ff,"\n");
 }
fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"%s\n",liniq.ravno());

fprintf(fil.ff,"%*s|",iceb_tu_kolbait(47,gettext("Итого")),gettext("Итого"));
printw("%*.*s|",
iceb_tu_kolbait(11,gettext("Сумма")),
iceb_tu_kolbait(11,gettext("Сумма")),
gettext("Сумма"));

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  fprintf(fil.ff,"%10.2f|",itogo[nom]);
  printw("%10.2f|",itogo[nom]);
 }

fprintf(fil.ff,"\n%*s|",iceb_tu_kolbait(47,gettext("НДС")),gettext("НДС"));

printw("\n%*.*s|",
iceb_tu_kolbait(11,gettext("НДС")),
iceb_tu_kolbait(11,gettext("НДС")),
gettext("НДС"));


for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  double suma_nds=itogo[nom]*all_nds.ravno_atof(nom)/100.;
  fprintf(fil.ff,"%10.2f|",suma_nds);
  printw("%10.2f|",suma_nds);
  itogo_snds[nom]=suma_nds;
 }

fprintf(fil.ff,"\n%*s|",iceb_tu_kolbait(47,gettext("Сумма с НДС")),gettext("Сумма с НДС"));

printw("\n%*.*s|",
iceb_tu_kolbait(11,gettext("Cумма с НДС")),
iceb_tu_kolbait(11,gettext("Cумма с НДС")),
gettext("Cумма с НДС"));

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  fprintf(fil.ff,"%10.2f|",itogo_snds[nom]+itogo[nom]);
  printw("%10.2f|",itogo_snds[nom]+itogo[nom]);
 }

fprintf(fil.ff,"\n%s\n",liniq.ravno());

printw("\n%s\n",liniqw.ravno());


iceb_t_podpis(fil.ff);



fil.end();

oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Распределение НДС по полученным услугам"));
oth->spis_imaf.plus(imaf_dok);
oth->spis_naim.plus(gettext("Протокол хода расчёта"));




iceb_t_ustpeh(imaf,3,&rh.orient);
iceb_t_rnl(imaf,&rh,&xuslpsnds_hap);

iceb_t_ustpeh(imaf_dok,3,&rh_dok.orient);
iceb_t_rnl(imaf_dok,&rh_dok,&xuslpsnds_hap_dok);

printw_vr(tmm);

OSTANOV();
return(0);

}

/*********************************/
/*шапка*/
/*********************************/

void xuslpsnds_hap(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"%s",rh->hapka.ravno());

}
/****************************/
/*шапка*/
/*****************************/
void xuslpsnds_hap_dok(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"\
---------------------------------------------------------------------------------------------------------\n");

fprintf(ff,"\
Дата докум|Подр.|Номер док.|Код усл.|   Наименование услуги        |Количество|   Цена   |  Сумма   |НДС|\n");
/***********
1234567890|12345|1234567890|12345678|123456789012345678901234567890|1234567890|1234567890|1234567890|123|123456789|
**************/

fprintf(ff,"\
---------------------------------------------------------------------------------------------------------\n");

}

/**************************/
/*Распечатка реквизитов поиска*/
/*******************************/

void xuslpsnds_rrp(class xuslpsnds_rk *rk,FILE *ff)
{

if(rk->kodop.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rk->kodop.ravno());

if(rk->kodgr.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код группы услуг"),rk->kodgr.ravno());

if(rk->kodop.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rk->kodop.ravno());

if(rk->kodusl.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код услуги"),rk->kodusl.ravno());

if(rk->shetu.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Счёт учёта"),rk->shetu.ravno());

}
