/*$Id:$*/
/*11.01.2022	25.11.2021	Белых А.И.	xmupsnds.cpp
Приход материалов с НДС
*/


#include        "buhg.h"
class xmupsnds_rk
 {
  public:

   class iceb_tu_str datan;
   class iceb_tu_str datak;
   class iceb_tu_str sklad;
   class iceb_tu_str kodop;
   class iceb_tu_str kodgr;
   class iceb_tu_str kodmat;
   class iceb_tu_str shetu;
   
   xmupsnds_rk()
    {
     clear();
    }  
   void clear()
    {
     datan.new_plus("");
     datak.new_plus("");
     sklad.new_plus("");
     kodop.new_plus("");
     kodgr.new_plus("");
     kodmat.new_plus("");
     shetu.new_plus("");
    }
   
 };


void xmupsnds_rrp(class xmupsnds_rk *rk,FILE *ff);
void xmupsnds_hap(class iceb_rnl_c *rd,int *kolstr,FILE *ff);
void xmupsnds_hap_dok(class iceb_rnl_c *rh,int *kolstr,FILE *ff);



int xmupsnds(class spis_oth *oth)
{
static class xmupsnds_rk rk;
int kom=0,kom1=0;
int kgr=0,kodm=0;

VVOD MENU(3);
VVOD VV(0);
VV.VVOD_spisok_add_ZAG(gettext("Распределение НДС по полученным материалам"));

VV.VVOD_spisok_add_data(rk.datan.ravno(),11);
VV.VVOD_spisok_add_data(rk.datak.ravno(),11);
VV.VVOD_spisok_add_data(rk.sklad.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodop.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodgr.ravno(),128);
VV.VVOD_spisok_add_data(rk.kodmat.ravno(),128);
VV.VVOD_spisok_add_data(rk.shetu.ravno(),128);


VV.VVOD_spisok_add_MD(gettext("Дата начала..............")); //0
VV.VVOD_spisok_add_MD(gettext("Дата конца...............")); //1
VV.VVOD_spisok_add_MD(gettext("Склад...(,,).............")); //2
VV.VVOD_spisok_add_MD(gettext("Код операции..(,,).......")); //3
VV.VVOD_spisok_add_MD(gettext("Код группы мат-ла...(,,).")); //4
VV.VVOD_spisok_add_MD(gettext("Код материалла..(,,).....")); //5
VV.VVOD_spisok_add_MD(gettext("Счёт учета.....(,,)......")); //6


naz:;
clear();

helstr(LINES-1,0,
//"F1",gettext("помощь"),
"F2/+",gettext("поиск"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

kom=VV.vvod(0,1,1,-1,-1);

rk.datan.new_plus(VV.data_ravno(0));
rk.datak.new_plus(VV.data_ravno(1));
rk.sklad.new_plus(VV.data_ravno(2));
rk.kodop.new_plus(VV.data_ravno(3));
rk.kodgr.new_plus(VV.data_ravno(4));
rk.kodmat.new_plus(VV.data_ravno(5));
rk.shetu.new_plus(VV.data_ravno(6));


class iceb_tu_str kods("");
class iceb_tu_str naims("");

switch (kom)
 {
  case ESC:
  case FK10:
     return(1);
     break;

  case FK1:
    GDITE();
//    iceb_t_pdoc("matu5_10.txt");
    clear();
    goto naz;

  case PLU:
  case FK2:
  case FK5:
     break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка складов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка групп"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка операций приходов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка материалов"));
    MENU.VVOD_spisok_add_MD(gettext("Просмотр списка счетов"));
    MENU.VVOD_spisok_add_MD(gettext("Выход"));

    clearstr(LINES-1,0);
    
    kom1=0;
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 5 :
      case -1:
       goto naz;

      case 0 :
        if(dirsklad(1,&rk.sklad,&naims) == 0)
         VV.data_z_plus(2,rk.sklad.ravno());
        goto naz;


      case 1 :
        vibrek("Grup",&rk.kodgr,&naims);
        VV.VVOD_spisok_zapis_data(4,rk.kodgr.ravno());
        goto naz;

      case 2 :
       if(dirprihod(1,&rk.kodop,&naims) == 0)
         VV.data_z_plus(3,rk.kodop.ravno());
        goto naz;

      case 3 :
        if(dirmatr(&kgr,&kodm,&naims,1,0,"",0,0) == 0)
         {
          VV.data_z_plus(5,kodm);
         }
        
        goto naz;

      case 4 :
        vibrek("Plansh",&rk.shetu,&naims);
        VV.VVOD_spisok_zapis_data(6,rk.shetu.ravno());
        goto naz;
               
     }
    goto naz;

  case FK4:
    VV.VVOD_clear_data();    
    goto naz;

  default:
    goto naz;
 }
short dn=0,mn=0,gn=0;
short dk=0,mk=0,gk=0;

if(iceb_t_rsdat(&dn,&mn,&gn,rk.datan.ravno(),&dk,&mk,&gk,rk.datak.ravno()) != 0)
 goto naz;

time_t tmm=0;
time(&tmm);

char strsql[1024];
int kolstr=0;
class SQLCURSOR cur;
class SQLCURSOR cur1;
SQL_str row,row1;
int kolstr1=0;

class iceb_tu_spisok all_nds;
class iceb_tu_spisok kodm_pnds;
class iceb_tu_double suma_kodm_pnds=0;
double suma=0.;
class iceb_tu_str naim_mat("");
class iceb_tu_str grupa("");
class iceb_tu_str shet_umat("");

sprintf(strsql,"select * from Zkart where datdp >= '%04d-%02d-%02d' and datdp <= '%04d-%02d-%02d' \
and tipz=1",gn,mn,dn,gk,mk,dk);


if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

class iceb_fopen fil;
char imaf_dok[64];
sprintf(imaf_dok,"rndsd%d.lst",getpid());
if(fil.start(imaf_dok,"w") != 0)
 return(1);

iceb_t_zagolov(gettext("Протокол хода расчёта по распределению НДС по материалам"),dn,mn,gn,dk,mk,gk,fil.ff);

xmupsnds_rrp(&rk,fil.ff);

class iceb_rnl_c rh_dok;
xmupsnds_hap_dok(&rh_dok,NULL,fil.ff);
class iceb_tu_str nds("");

while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);

  if(iceb_tu_proverka(rk.sklad.ravno(),row[0],0,0) != 0)
   continue;

  /*читаем реквизиты карточки материала*/
  sprintf(strsql,"select kodm,shetu,nds from Kart where sklad=%s and nomk=%s",row[0],row[1]);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) <= 0)
   { 
    continue;
   }

  int kodmat=atoi(row1[0]);
  shet_umat.new_plus(row1[1]);
  nds.new_plus(row1[2]);


            
  if(iceb_tu_proverka(rk.kodmat.ravno(),kodmat,0,0) != 0)
   continue;

  if(iceb_tu_proverka(rk.shetu.ravno(),shet_umat.ravno(),1,0) != 0)
     continue;              


  if(rk.kodop.getdlinna() > 1)
   {
    sprintf(strsql,"select kodop from Dokummat where datd='%s' and sklad=%s and nomd='%s'",
    row[4],row[0],row[2]);
    if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
     {
      if(iceb_tu_proverka(rk.kodop.ravno(),row1[0],0,0) != 0)
       continue;
     }

   }
   
  /*узнаём наименование материала*/
  sprintf(strsql,"select kodgr,naimat from Material where kodm=%d",kodmat);

  if(iceb_t_sql_readkey(strsql,&row1,&cur1) > 0)
   {
    grupa.new_plus(row1[0]);
    naim_mat.new_plus(row1[1]);
   }
  else 
   {
    grupa.new_plus("");
    naim_mat.new_plus("");   
   }

  if(rk.kodgr.getdlinna() > 1)
   {
    if(iceb_tu_proverka(rk.kodgr.ravno(),grupa.ravno(),0,0) != 0)
     continue;    
   }
  
  printw("%s|%-5s|%-10s|%-8d|%-*.*s|%10.10g|%10.10g|%10.2f|%-3s|%-9s|\n",
  iceb_tu_datzap(row[3]),row[0],row[2],kodmat,
  iceb_tu_kolbait(30,naim_mat.ravno()),
  iceb_tu_kolbait(30,naim_mat.ravno()),
  naim_mat.ravno(),  
  atof(row[6]),atof(row[7]),suma,nds.ravno(),row[1]);

  suma=atof(row[6])*atof(row[7]);
    

  fprintf(fil.ff,"%s|%-5s|%-10s|%-8d|%-*.*s|%10.10g|%10.10g|%10.2f|%-3s|%-9s|\n",
  iceb_tu_datzap(row[3]),row[0],row[2],kodmat,
  iceb_tu_kolbait(30,naim_mat.ravno()),
  iceb_tu_kolbait(30,naim_mat.ravno()),
  naim_mat.ravno(),  
  atof(row[6]),atof(row[7]),suma,nds.ravno(),row[1]);
  
  /*если НДС равно нулю то узнаём какой это вариант нулевого НДС*/
  if(nds.ravno_atof() == 0.)
   {
    sprintf(strsql,"SELECT sodz FROM Dokummat2 WHERE god=%d and nomd='%s' and sklad=%d and nomerz=11",
    atoi(row[4]),row[2],atoi(row[0]));
    if(iceb_t_sql_readkey(strsql,&row1,&cur1) <= 0)
     nds.plus("-?");
    else
     nds.plus("-",row1[0]);

   }





  if(all_nds.find(nds.ravno()) < 0)
   all_nds.plus(nds.ravno());

  sprintf(strsql,"%d|%s",kodmat,nds.ravno());
  if((kom=kodm_pnds.find(strsql)) >= 0)  
   {
    suma_kodm_pnds.plus(suma,kom);
   }
  else
   {
    kodm_pnds.plus(strsql);
    suma_kodm_pnds.plus(suma);
   }
 }

fprintf(fil.ff,"ICEB_LST_END\n");
fprintf(fil.ff,"\
-------------------------------------------------------------------------------------------------------------------\n");

iceb_t_podpis(fil.ff);
fil.end();



char imaf[64];
sprintf(imaf,"rnds%d.lst",getpid());
if(fil.start(imaf,"w") != 0)
 return(1);
iceb_t_zagolov(gettext("Распределение НДС по полученным материалам"),dn,mn,gn,dk,mk,gk,fil.ff);
xmupsnds_rrp(&rk,fil.ff);

class iceb_rnl_c rh;

class iceb_tu_str liniq("------------------------------------------------");
class iceb_tu_str liniqw("------------");
for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  liniq.plus("-----------");
  liniqw.plus("-----------");
 }

/*формируем шапку распечатки*/
rh.hapka.new_plus(liniq.ravno());
rh.hapka.plus("\n");
printw("%s\n",liniqw.ravno());

rh.hapka.plus(gettext("Код м.|        Наименование материала          |"));
/*******
                       123456|1234567890123456789012345678901234567890|
***********/

printw("           |");

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  sprintf(strsql,"%10s|",all_nds.ravno(nom));
  rh.hapka.plus(strsql);
  printw("%s",strsql);
 }

sprintf(strsql,"\n%s\n",liniq.ravno());
rh.hapka.plus(strsql);
printw("\n%s\n",liniqw.ravno());

xmupsnds_hap(&rh,NULL,fil.ff);


double itogo[all_nds.kolih()];
double itogo_snds[all_nds.kolih()];

for(int nom=0; nom < all_nds.kolih();nom++)
 itogo[nom]=0.;
 
for(int nom=0; nom < kodm_pnds.kolih(); nom++)
 {

  iceb_tu_polen(kodm_pnds.ravno(nom),&kodm,1,'|');
  iceb_tu_polen(kodm_pnds.ravno(nom),&nds,2,'|');
  
  int nom_nds=all_nds.find(nds.ravno());
  double nom_suma=suma_kodm_pnds.ravno(nom);
      
  itogo[nom_nds]+=nom_suma;
  
  /*узнаём наименование материала*/
  sprintf(strsql,"select naimat from Material where kodm=%d",kodm);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) > 0)
   naim_mat.new_plus(row1[0]);
  else 
   naim_mat.new_plus("");   

  fprintf(fil.ff,"%6d|%-*.*s|",
  kodm,
  iceb_tu_kolbait(40,naim_mat.ravno()),
  iceb_tu_kolbait(40,naim_mat.ravno()),
  naim_mat.ravno());
    
  for(int shetchik_nds=0; shetchik_nds < all_nds.kolih(); shetchik_nds++)
   {
    
    if(nom_nds == shetchik_nds)
     {
      fprintf(fil.ff,"%10.2f|",nom_suma);
     }
    else
     {
      fprintf(fil.ff,"          |");
     }
   }
  fprintf(fil.ff,"\n");
 }
fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"%s\n",liniq.ravno());

fprintf(fil.ff,"%*s|",iceb_tu_kolbait(47,gettext("Итого")),gettext("Итого"));

printw("%*.*s|",
iceb_tu_kolbait(11,gettext("Сумма")),
iceb_tu_kolbait(11,gettext("Сумма")),
gettext("Сумма"));

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  fprintf(fil.ff,"%10.2f|",itogo[nom]);
  printw("%10.2f|",itogo[nom]);
 }

fprintf(fil.ff,"\n%*s|",iceb_tu_kolbait(47,gettext("НДС")),gettext("НДС"));
printw("\n%*.*s|",
iceb_tu_kolbait(11,gettext("НДС")),
iceb_tu_kolbait(11,gettext("НДС")),
gettext("НДС"));

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  double suma_nds=itogo[nom]*all_nds.ravno_atof(nom)/100.;
  fprintf(fil.ff,"%10.2f|",suma_nds);
  printw("%10.2f|",suma_nds);
  itogo_snds[nom]=suma_nds;
 }

fprintf(fil.ff,"\n%*s|",iceb_tu_kolbait(47,gettext("Сумма с НДС")),gettext("Сумма с НДС"));
printw("\n%*.*s|",
iceb_tu_kolbait(11,gettext("Cумма с НДС")),
iceb_tu_kolbait(11,gettext("Cумма с НДС")),
gettext("Cумма с НДС"));

for(int nom=0; nom < all_nds.kolih(); nom++)
 {
  fprintf(fil.ff,"%10.2f|",itogo_snds[nom]+itogo[nom]);
  printw("%10.2f|",itogo_snds[nom]+itogo[nom]);
 }

fprintf(fil.ff,"\n%s\n",liniq.ravno());
printw("\n%s\n",liniqw.ravno());


iceb_t_podpis(fil.ff);



fil.end();

oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Распределение НДС по полученным материалам"));
oth->spis_imaf.plus(imaf_dok);
oth->spis_naim.plus(gettext("Протокол хода расчёта"));




iceb_t_ustpeh(imaf,3,&rh.orient);
iceb_t_rnl(imaf,&rh,&xmupsnds_hap);

iceb_t_ustpeh(imaf_dok,3,&rh_dok.orient);
iceb_t_rnl(imaf_dok,&rh_dok,&xmupsnds_hap_dok);

printw_vr(tmm);
OSTANOV();
return(0);

}

/*********************************/
/*шапка*/
/*********************************/

void xmupsnds_hap(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"%s",rh->hapka.ravno());

}
/****************************/
/*шапка*/
/*****************************/
void xmupsnds_hap_dok(class iceb_rnl_c *rh,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr=*kolstr+3;

fprintf(ff,"\
-------------------------------------------------------------------------------------------------------------------\n");

fprintf(ff,"\
Дата докум|Склад|Номер док.|Код мат.|   Наименование материала     |Количество|   Цена   |  Сумма   |НДС|Ном.карт.|\n");
/***********
1234567890|12345|1234567890|12345678|123456789012345678901234567890|1234567890|1234567890|1234567890|123|123456789|
**************/

fprintf(ff,"\
-------------------------------------------------------------------------------------------------------------------\n");

}

/**************************/
/*Распечатка реквизитов поиска*/
/*******************************/

void xmupsnds_rrp(class xmupsnds_rk *rk,FILE *ff)
{

if(rk->kodop.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rk->kodop.ravno());

if(rk->kodgr.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код группы материала"),rk->kodgr.ravno());

if(rk->kodop.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код операции"),rk->kodop.ravno());

if(rk->kodmat.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Код материала"),rk->kodmat.ravno());

if(rk->shetu.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Счёт учёта"),rk->shetu.ravno());

}
