/*$Id:$*/
/*27.11.2024	07.10.2024	Белых А.И.	uosso.cpp
Отчёт о состоянии объектов основных средств
*/

#include "buhg.h"
#include "poiinpd.h"
#include "bsizt.h"

class uosso_poi
 {
  public:
   class iceb_tu_str datar;
   class iceb_tu_str innom;
   class iceb_tu_str grup_buh;
   class iceb_tu_str grup_nal;
   class iceb_tu_str shet_uh;
   class iceb_tu_str mat_ot;
   class iceb_tu_str hifr_zat;
   class iceb_tu_str podr;
   
   uosso_poi()
    {
     clear_data();
    }

   void clear_data()
    {
     datar.new_plus("");
     innom.new_plus("");
     grup_buh.new_plus("");
     grup_nal.new_plus("");
     shet_uh.new_plus("");
     mat_ot.new_plus("");
     hifr_zat.new_plus("");
     podr.new_plus("");
    }

 };


void uosso_hs(class iceb_rnl_c *rh,int *nom_str,FILE *ff);
void uosso_rpoi(class uosso_poi *poi,FILE *ff);

int uosso(class spis_oth *oth)
{
int kom=0,kom1=0;
static class uosso_poi poi;
class iceb_tu_str naim_v("");
class iceb_tu_str kod_v("");

class VVOD MENU(3);
class VVOD VV(0);
VV.VVOD_spisok_add_data(poi.datar.ravno(),11);
VV.VVOD_spisok_add_data(poi.shet_uh.ravno(),256);
VV.VVOD_spisok_add_data(poi.innom.ravno(),256);
VV.VVOD_spisok_add_data(poi.grup_buh.ravno(),256);
VV.VVOD_spisok_add_data(poi.grup_nal.ravno(),256);
VV.VVOD_spisok_add_data(poi.mat_ot.ravno(),256);
VV.VVOD_spisok_add_data(poi.podr.ravno(),256);
VV.VVOD_spisok_add_data(poi.hifr_zat.ravno(),256);

VV.VVOD_spisok_add_MD(gettext("По состоянию на.(д.м.г)."));//0
VV.VVOD_spisok_add_MD(gettext("Счёт учёта.........(,,)."));//1
VV.VVOD_spisok_add_MD(gettext("Інвентарний номер..(,,)."));//2
VV.VVOD_spisok_add_MD(gettext("Группа бух.учёта...(,,)."));//3
VV.VVOD_spisok_add_MD(gettext("Группа нал.учёта...(,,)."));//4
VV.VVOD_spisok_add_MD(gettext("Мат. ответственный.(,,)."));//5
VV.VVOD_spisok_add_MD(gettext("Подразделение......(,,)."));//6
VV.VVOD_spisok_add_MD(gettext("Шифр затрат........(,,)."));//7


VV.VVOD_spisok_add_ZAG(gettext("Распечатка информации о состоянии основных средств"));

naz:;

clear();

helstr(LINES-1,0,
//"F1",gettext("помощь"),
"F2/+",gettext("расчёт"),
"F3",gettext("реквизиты"),
"F4",gettext("очистить"),
"F10",gettext("выход"),NULL);

kom=VV.vvod(0,1,1,-1,-1);

poi.datar.new_plus(VV.data_ravno(0));
poi.shet_uh.new_plus(VV.data_ravno(1));
poi.innom.new_plus(VV.data_ravno(2));
poi.grup_buh.new_plus(VV.data_ravno(3));
poi.grup_nal.new_plus(VV.data_ravno(4));
poi.mat_ot.new_plus(VV.data_ravno(5));
poi.podr.new_plus(VV.data_ravno(6));
poi.hifr_zat.new_plus(VV.data_ravno(7));

switch (kom)
 {

  case FK10:
  case ESC:
   return(1);

  case FK1:
    GDITE();
//    iceb_t_prosf(bros);
//    clear();
    goto naz;

  case FK2:
  case PLU:
    break;

  case FK3:
    MENU.VVOD_delete();
    MENU.VVOD_spisok_add_MD(gettext("Просмотр групп бух. учёта")); //0
    MENU.VVOD_spisok_add_MD(gettext("Просмотр групп нал. учёта"));//1
    MENU.VVOD_spisok_add_MD(gettext("Просмотр материально ответственных"));//2
    MENU.VVOD_spisok_add_MD(gettext("Просмотр подразделений"));//3
    MENU.VVOD_spisok_add_MD(gettext("Просмотр шифров затрат"));//4
    MENU.VVOD_spisok_add_MD(gettext("Выход"));//5

    clearstr(LINES-1,0);
    kom1=0;    
    while(menu3w(stdscr,&MENU,&kom1,-1,-1,0) != 0);

    switch (kom1)
     {
      case 5 :
      case -1:
       goto naz;

      case 0 :
        vibrek("Uosgrup1",&poi.grup_buh,&naim_v);
        VV.VVOD_spisok_zapis_data(3,poi.grup_buh.ravno());
        goto naz;

      case 1 :
        vibrek("Uosgrup",&poi.grup_nal,&naim_v);
        VV.VVOD_spisok_zapis_data(4,poi.grup_nal.ravno());
        goto naz;

        
      case 2 :
        if(dirmatot(1,&kod_v,&naim_v,0) == 0)
         VV.data_z_plus(5,kod_v.ravno());
        goto naz;

      case 3 :
        if(diruospod(1,&kod_v,&naim_v,0) == 0)
         VV.data_z_plus(6,kod_v.ravno());
        goto naz;

      case 4 :
        vibrek("Uoshz",&poi.hifr_zat,&naim_v);
        VV.data_z_plus(7,poi.hifr_zat.ravno());
        goto naz;

     }
    goto naz;

  case FK4:
    VV.VVOD_clear_data();
    goto naz;


  default:
    goto naz;
 }

short dn=0,mn=0,gn=0;

if(iceb_tu_rsdat(&dn,&mn,&gn,poi.datar.ravno(),1) != 0)
 {
  iceb_t_soob(gettext("Не правильно введена дата!"));
  goto naz;
 }

class SQLCURSOR cur,cur1;
class iceb_tu_str naim_hzbu("");
class iceb_tu_str naim_hznu("");
SQL_str row,row1;
int kolstr=0,kolstr1=0;
char strsql[1024];
char imaf[64];
char imaf_csv[64];
int in=0;
int poddz=0,kodotl=0;
class iceb_tu_str fio_mo("");
int nomer_str=0;
class poiinpdw_data rekin;
double lik_st_nu=0.;
double lik_st_bu=0.;
double bal_stoim_nu=0.,bal_stoim_bu=0.;
double iznos_nu=0.,iznos_bu=0.;
double itogo[6];
memset(&itogo,'\0',sizeof(itogo));


sprintf(strsql,"select innom,god,naim,datvv from Uosin order by innom asc");

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

class iceb_fopen fil;

sprintf(imaf,"uosso%d.lst",getpid());

if(fil.start(imaf,"w") != 0)
 return(1);

iceb_t_zagolov(gettext("Информация о состоянии основных средств"),0,0,0,dn,mn,gn,fil.ff);
uosso_rpoi(&poi,fil.ff);

class iceb_fopen fil_csv;

sprintf(imaf_csv,"uosso%d.csv",getpid());

if(fil_csv.start(imaf_csv,"w") != 0)
 return(1);

iceb_t_zagolov(gettext("Информация о состоянии основных средств"),0,0,0,dn,mn,gn,fil_csv.ff);
uosso_rpoi(&poi,fil_csv.ff);

fprintf(fil_csv.ff,"N п/п|Назва|Інвентарний номер|Рік випуску|Дата введення в експлуатацію|Срок корисного використання|\
Матеріально-відповідальна особа|Амортизаційні відрахування|Первісна вартість|Ліквідаційна вартість|Сума зносу|\
Первісна вартість|Ліквідаційна вартість|Сума зносу|\
Поправочний коефіцієнт б/н|Шифр витрат б/н|\n");

class iceb_rnl_c rh;

uosso_hs(&rh,NULL,fil.ff);

while(cur.read_cursor(&row) != 0)
 {
  strzag(LINES-1,0,kolstr,++kolstr1);
  
  if(iceb_tu_proverka(poi.innom.ravno(),row[0],0,0) != 0)
   continue;
  
  in=atoi(row[0]);
   
  if(poiin(in,dn,mn,gn,&poddz,&kodotl) != 0)
    continue;


  poiinpd(in,mn,gn,&rekin); /*смотрим реквизиты*/

  if(iceb_tu_proverka(poi.shet_uh.ravno(),rekin.shetu.ravno(),1,0) != 0)
   continue;
  if(iceb_tu_proverka(poi.hifr_zat.ravno(),rekin.hzt.ravno(),1,0) != 0)
   continue;

  if(iceb_tu_proverka(poi.grup_buh.ravno(),rekin.hnaby.ravno(),0,0) != 0)
   continue;

  if(iceb_tu_proverka(poi.grup_nal.ravno(),rekin.hna.ravno(),0,0) != 0)
   continue;

  if(iceb_tu_proverka(poi.podr.ravno(),poddz,0,0) != 0)
   continue;

  if(iceb_tu_proverka(poi.mat_ot.ravno(),kodotl,0,0) != 0)
   continue;


  class bsizw_data bal_st;
  bsiz(in,poddz,dn,mn,gn,&bal_st,NULL);

  bal_stoim_nu=bal_st.sbs+bal_st.bs;
  iznos_nu=bal_st.siz+bal_st.iz+bal_st.iz1;
 
  bal_stoim_bu=bal_st.sbsby+bal_st.bsby;
  iznos_bu=bal_st.sizby+bal_st.izby+bal_st.iz1by;

  lik_st_nu=uosgetls(in,dn,mn,gn,0);
  lik_st_bu=uosgetls(in,dn,mn,gn,1);

  itogo[0]+=bal_stoim_bu;
  itogo[1]+=lik_st_bu;
  itogo[2]+=iznos_bu;

  itogo[3]+=bal_stoim_nu;
  itogo[4]+=lik_st_nu;
  itogo[5]+=iznos_nu;
  
  double kof_bu=1.;
  double kof_nu=1;
  int vrabu=0.;
  double amort_mes=0.;        
  int kol_let=0;
  naim_hzbu.new_plus("");
  naim_hznu.new_plus("");
  
  /*Читаем коэффициент для нал. учёта*/
  sprintf(strsql,"select naik,kof from Uosgrup where kod='%s'",rekin.hna.ravno());
  if(sql_readkey(&bd,strsql,&row1,&cur1) == 1)
   {
    kof_nu=atof(row1[1]);
    naim_hznu.new_plus(row1[0]);
   }
  /*Читаем коэффициент для бух. учёта*/
  sprintf(strsql,"select naik,kof,ar from Uosgrup1 where kod='%s'",rekin.hnaby.ravno());
  if(sql_readkey(&bd,strsql,&row1,&cur1) == 1)
   {
    kof_bu=atof(row1[1]);
    vrabu=atoi(row1[3]);
    naim_hzbu.new_plus(row1[0]);
   }

  if(vrabu == 1)
   {
    amort_mes=(bal_st.bsby-bal_st.izby)*rekin.popkfby*kof_bu/100/12.;
    if(amort_mes > 0.)
      kol_let=(bal_st.bsby-bal_st.izby)/amort_mes/12;
   }
  else
   {    
    amort_mes=bal_st.bsby*rekin.popkfby*kof_bu/100/12.;
    if(amort_mes > 0.)
     kol_let=bal_st.bsby/amort_mes/12;
   }


  sprintf(strsql,"select naik from Uosol where kod=%d",kodotl);
  if(iceb_t_sql_readkey(strsql,&row1,&cur1) == 1)
   fio_mo.new_plus(row1[0]);
  else
   fio_mo.new_plus("");   
  
  sprintf(strsql,"%f/%f",rekin.popkfby,rekin.popkf);
  
  fprintf(fil.ff,"%6d|%-*.*s|%-11d|%-7s|%10s|%-9d|%-*.*s|%-*s|\
%11.2f|%11.2f|%11.2f|%11.2f|%11.2f|%11.2f|%-20s|%f %s/%f %s\n",
  ++nomer_str,
  iceb_tu_kolbait(30,row[2]),
  iceb_tu_kolbait(30,row[2]),
  row[2],
  in,
  row[1],
  iceb_tu_datzap(row[3]),                    
  kol_let,
  iceb_tu_kolbait(12,fio_mo.ravno()),    
  iceb_tu_kolbait(12,fio_mo.ravno()),    
  fio_mo.ravno(),
  iceb_tu_kolbait(13,rekin.hzt.ravno()),
  rekin.hzt.ravno(),
  bal_stoim_bu,
  lik_st_bu,
  iznos_bu,    
  bal_stoim_nu,
  lik_st_nu,
  iznos_nu,
  strsql,
  kof_bu,naim_hzbu.ravno(),
  kof_nu,naim_hznu.ravno());

  fprintf(fil_csv.ff,"%d|%s|%d|%s|%s|%d|%s|%s|\
%.2f|%.2f|%.2f|%.2f|%.2f|%.2f|%-11s|%f %s/%f %s\n",
  nomer_str,
  row[2],
  in,
  row[1],
  iceb_tu_datzap(row[3]),                    
  kol_let,
  fio_mo.ravno(),
  rekin.hzt.ravno(),
  bal_stoim_bu,
  lik_st_bu,
  iznos_bu,    
  bal_stoim_nu,
  lik_st_nu,
  iznos_nu,
  strsql,
  kof_bu,naim_hzbu.ravno(),
  kof_nu,naim_hznu.ravno());
 }

fprintf(fil.ff,"ICEB_LST_END\n");

fprintf(fil.ff,"\
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

fprintf(fil.ff,"%*s|%11.2f|%11.2f|%11.2f|%11.2f|%11.2f|%11.2f|\n",
    iceb_tu_kolbait(105,gettext("Итого")),
    gettext("Итого"),
    itogo[0],
    itogo[1],
    itogo[2],
    itogo[3],
    itogo[4],
    itogo[5]);
    
fprintf(fil.ff,"%*s_________________________\n\n",iceb_tu_kolbait(20,gettext("Руководитель")),gettext("Руководитель"));
fprintf(fil.ff,"%*s_________________________\n\n",iceb_tu_kolbait(20,gettext("Главный бухгалтер")),gettext("Главный бухгалтер"));


iceb_t_podpis(fil.ff);
iceb_t_podpis(fil_csv.ff);

fil.end();
fil_csv.end();


iceb_t_ustpeh(imaf,3,&rh.orient);
iceb_t_rnl(imaf,&rh,&uosso_hs);

oth->spis_imaf.plus(imaf);
oth->spis_naim.plus(gettext("Распечатка основных средств"));
oth->spis_imaf.plus(imaf_csv);
oth->spis_naim.plus(gettext("Распечатка основных средств в формате csv"));


return(0);
}
/********************************************************************************************************************/
/*шапка распечатки*/
/***********************************************************************************************/

void uosso_hs(class iceb_rnl_c *rh,int *nom_str,FILE *ff)
{
if(nom_str != NULL)
  *nom_str+=7;
fprintf(ff,"\
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(ff,"\
  N   |           Назва              |Інвентарний|  Рік  |   Дата   |  Срок   |Матеріально-|Амортизаційні|     Бухгалтерський облік          |      Податковий облік             |                    |           |\n\
 п/п  |                              |   номер   |випуску| введення |корисного|відповідаль.|відрахування |-----------------------------------------------------------------------|     Поправочний    |Шифр витрат|\n\
      |                              |           |       |          |використ.|   особа    |             | Первісна  |Ліквідацій-|   Сума    | Первісна  |Ліквідацій-|   Сума    |     коефіцієнт     |    б/п    |\n\
      |                              |           |       |          |         |            |             | вартість  |   на      |  зносу    | вартість  |   на      |  зносу    |         б/п        |           |\n\
      |                              |           |       |          |         |            |             |           | вартість  |           |           | вартість  |           |                    |           |\n");
fprintf(ff,"\
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

/*
123456|123456789012345678901234567890|12345678901|1234567|1234567890|123456789|123456789012|1234567890123|12345678901|12345678901|12345678901|12345678901|12345678901|12345678901|12345678901234567890|
*/
}
/***************************************************************/
/*вывод реквизитов поиска*/
/*************************************/
void uosso_rpoi(class uosso_poi *poi,FILE *ff)
{

if(poi->shet_uh.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Счёт учёта"),poi->shet_uh.ravno());

if(poi->innom.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Инвентарный номер"),poi->innom.ravno());

if(poi->grup_buh.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Группа бух. учёта"),poi->grup_buh.ravno());

if(poi->grup_nal.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Группа нал. учёта"),poi->grup_nal.ravno());

if(poi->mat_ot.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Материально ответственное лицо"),poi->mat_ot.ravno());

if(poi->hifr_zat.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Шифр затрат"),poi->hifr_zat.ravno());

if(poi->podr.getdlinna() > 1)
 fprintf(ff,"%s:%s\n",gettext("Подразделение"),poi->podr.ravno());

}
