/*$Id:$*/
/*28.01.2024	26.01.2024	Белых А.И.	b_ukrsib_busines.cpp

Экспорт платёжек для системы iBank 2 UA
Кодировка Cp1251
---------------------------------------------------------------
Наименование        Описание                        Тип        
поля
---------------------------------------------------------------
DATE_DOC          Дата документа                    date     10
NUM_DOC           Номер документа                   string   10
AMOUNT            Сумма документа                   decimal  12.2
CLN_NAME          Наименование плательщика          string   40
CLN_OKPO          ЕГРПОУ плательщика                string   10
CLN_ACCOUNT       Счёт плательщика                  string   29
CLN_BANK_NAME     Наименование банка плательщика    string   45
CLN_BANK_MFO      МФО банка плательщика             string   6
CLN_COUNTRY_CODE  Код країни платника               string   3
RCPT_NAME         Наименование получателя           string   40
RCPT_OKPO         ЕГРПОУ получателя                 string   10
RCPT_ACCOUNT      Счёт получателя                   string   29
RCPT_BANK_NAME    Наименование банка получателя     string   45
RCPT_BANK_MFO     МФО банка получателя              string   6
RCPT_COUNTRY_CODE Код країни отримувача в буквеному string 2  Якщо в полі «RCPT_OKPO» вказано        Код країни отримувача в буквеному
                  форматі (2 латинські літери, що             значення «000000000»                   форматі (2 латинські літери, що
                  відповідають довіднику країн)               Контроль:                              відповідають довіднику країн)
                                                              Не може містити значення «UA» –
                                                              код України – для отримувача-
                                                              нерезидента
PAYMENT_DETAILS   Назначение платежа              string   420
VALUE_DATE        Дата валютирования              date     10
RCPT_PASSP_SER    Серия паспорта                  string   2    Серия и номер паспорта соответственно, заполняется для
RCPT_PASSP_NUM    Номер паспорта                  string   9    получателей физ. лиц, если RCPT_OKPO равен 10 нулям

               Структуроване призначення платежу. Дані першого блоку
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
 Назва поля        Тип даних  Обов’язковістьнаявності   Обов’язковість наявності та  Умови та контролі                         Опис  
                                                                заповнення                                                       
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.CODE         STRING(3)    Ні                        Так – за умови            1. Якщо в IBAN з 5 по 10 символ           Код виду сплати (ISO - Certificate Identification)
                                                                                      включно зазначено значення  "899998" 
                                                                                     2. Якщо заповнено хоча б одне з 
                                                                                      полів SPD.1.***
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.AMOUNT       NUMBER(12.2) Ні                        Так – за умови            1. Якщо в IBAN з 5 по 10 символ           Сума податку (ISO - Total Amount)               
                                                                                     включно зазначено значення  "899998"
                                                                                    2. Якщо заповнено хоча б одне з
                                                                                      полів SPD.1.***
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.ADD_INFO    STRING(140)   Ні                        Так – за умови            1. Якщо в IBAN з 5 по 10 символ           Додаткова інформація запису (ISO - Additional Information) - інформація про податок, його період
                                                                                     включно зазначено значення  "899998"
                                                                                    2. Якщо заповнено хоча б одне з
                                                                                      полів SPD.1.***
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.ACCOUNT     STRING(29)    Ні                        Так – за умови             Якщо додатково заповнено хоча б         Номер рахунку (ISO - Category Details) 
                                                                                     одне з полів SPD.2.*** або
                                                                                     SPD.3.*** (это дополнительные
                                                                                     блоки которые могут быть)
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.TAX_DETAILS STRING(140)   Нi                        Нi                                                                 Інформація про податкове повідомлення (рішення) (ISO - Category
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               
SPD.1.TYPE        STRING(8)     Нi                        Нi                                                                 Тип (ISO - Type)
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------               


*/


#include        <errno.h>                                                       
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int  b_ukrsib_business(const char *tabl)
{
char		imaf1[64];
class iceb_tu_str koment("");
char		strsql[1024];
short		d,m,g;
int kolstr=0;
SQL_str row;
class SQLCURSOR cur;
class iceb_tu_str bp_taxcode("");
char metka_bs[10]; /*цепочка символов с IBAN з 5 по 10 символ включно*/
const char *metka_bs_etalon="899998";
short metka_kod_bd_plat=0;/*код бюджетного платежа*/
short metka_np=0; /*метка небюджетных платёжек*/

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }



class iceb_fopen fil;
sprintf(imaf1,"plat.txt");
if(fil.start(imaf1,"w") != 0)
 return(1);

fprintf(fil.ff,"Content-Type=doc/ua_payment\n\n");
short dv,mv,gv;

/*Так как в системе предусморено только 40 символов для наименования организации то нужно брать короткое наименование*/

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);
  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  memset(metka_bs,'\0',sizeof(metka_bs));
    
  /*смотрим номер счёта контрагента с 5 по 10 знак*/
  for(int nom=4; nom < 10; nom++)
   {
    metka_bs[nom-4]=rec.nsh1.ravno()[nom];      
   }

  if(iceb_tu_SRAV(metka_bs_etalon,metka_bs,0) == 0) /*бюджетный платёж*/
   {
    if(metka_np == 1)
     {
      beep();
      iceb_t_soob(gettext("Бюджетные и небюджетные платёжки в одном пакете!"));
      return(1);
     }
    if(metka_kod_bd_plat == 0)
     {
      VVOD VVOD1(2);
      VVOD1.VVOD_spisok_add_MD(gettext("Введите код уплаты бюджетного платежа"));
      vvod1(&bp_taxcode,6,&VVOD1,NULL,stdscr,-1,-1);
     }
    metka_kod_bd_plat=1;
   }  
  else
   {
    if(metka_kod_bd_plat == 1)
     {
      iceb_t_soob(gettext("Бюджетные и небюджетные платёжки в одном пакете!"));
      return(1);
     }
    metka_np=1;
   }

  class iceb_tu_str naior(rec.naior.ravno());
  class iceb_tu_str naior1(rec.naior1.ravno());
 
  if(iceb_tu_strlen(rec.naior.ravno()) > 40)
   {
    naior.new_plus(iceb_t_get_pnk(rec.kodor.ravno(),0));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 40 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_t_soob(strsql);

   }
  if(iceb_tu_strlen(rec.naior1.ravno()) > 40)
   {
    if(rec.kodor1.getdlinna() > 1) /*При выборе контрагента из файла код контрагента может быть не определён*/
     {
      naior1.new_plus(iceb_t_get_pnk(rec.kodor1.ravno(),0));

      sprintf(strsql,"%s %s %s\n%s %s",
      gettext("Наименование контрагента"),
      rec.naior1.ravno(),
      gettext("больше 40 символов"),
      gettext("заменили на короткое"),
      naior1.ravno());

      iceb_t_soob(strsql);


     }
   }

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  dv=rec.dv;
  mv=rec.mv;
  gv=rec.gv;
  if(dv == 0)
   {
    dv=d;
    mv=m;
    gv=g;
   }
  if(bp_taxcode.getdlinna() <= 1)
   fprintf(fil.ff,"\
DATE_DOC=%02d.%02d.%04d\n\
NUM_DOC=%s\n\
AMOUNT=%.2f\n\
CLN_NAME=%.*s\n\
CLN_OKPO=%s\n\
CLN_ACCOUNT=%s\n\
CLN_BANK_NAME=%.*s\n\
CLN_BANK_MFO=%s\n\
RCPT_NAME=%.*s\n\
RCPT_OKPO=%s\n\
RCPT_ACCOUNT=%s\n\
RCPT_BANK_NAME=%.*s\n\
RCPT_BANK_MFO=%.6s\n\
PAYMENT_DETAILS=%.*s\n\
VALUE_DATE=%02d.%02d.%04d\n\n",
   d,m,g,
   row[1],
   rec.sumd,
   iceb_tu_kolbait(40,naior.ravno()),naior.ravno(),
   rec.kod.ravno(),
   rec.nsh.ravno(),
   iceb_tu_kolbait(45,rec.naiban.ravno()),rec.naiban.ravno(),
   rec.mfo.ravno(),
   iceb_tu_kolbait(40,naior1.ravno()),naior1.ravno(),
   rec.kod1.ravno(),
   rec.nsh1.ravno(),
   iceb_tu_kolbait(45,rec.naiban1.ravno()),rec.naiban1.ravno(),
   rec.mfo1.ravno(),
   iceb_tu_kolbait(420,koment.ravno()),koment.ravno(),
   dv,mv,gv);
  else
   fprintf(fil.ff,"\
DATE_DOC=%02d.%02d.%04d\n\
NUM_DOC=%s\n\
AMOUNT=%.2f\n\
CLN_NAME=%.*s\n\
CLN_OKPO=%s\n\
CLN_ACCOUNT=%s\n\
CLN_BANK_NAME=%.*s\n\
CLN_BANK_MFO=%s\n\
RCPT_NAME=%.*s\n\
RCPT_OKPO=%s\n\
RCPT_ACCOUNT=%s\n\
RCPT_BANK_NAME=%.*s\n\
RCPT_BANK_MFO=%.6s\n\
PAYMENT_DETAILS=%.*s\n\
SPD.1.CODE=%s\n\
SPD.1.AMOUNT=%.2f\n\
SPD.1.ADD_INFO=%.420s\n\
VALUE_DATE=%02d.%02d.%04d\n\n",
   d,m,g,
   row[1],
   rec.sumd,
   iceb_tu_kolbait(40,naior.ravno()),naior.ravno(),
   rec.kod.ravno(),
   rec.nsh.ravno(),
   iceb_tu_kolbait(45,rec.naiban.ravno()),rec.naiban.ravno(),
   rec.mfo.ravno(),
   iceb_tu_kolbait(40,naior1.ravno()),naior1.ravno(),
   rec.kod1.ravno(),
   rec.nsh1.ravno(),
   iceb_tu_kolbait(45,rec.naiban1.ravno()),rec.naiban1.ravno(),
   rec.mfo1.ravno(),
   iceb_tu_kolbait(420,koment.ravno()),koment.ravno(),
   bp_taxcode.ravno(),   
   rec.sumd,
   koment.ravno(),
   dv,mv,gv);

 }

fil.end();
//iceb_t_perecod(2,imaf1);
return(0);
}
