/*$Id:$*/
/*12.04.2023	02.02.2022	Белых А.И.	b_corpex_csv.cpp
Платёжка в формате csv

         !!!!!!!!!!!   Новый формат    !!!!!!!!!!!!!!!!!!


Імпорт платіжної інструкції в національній валюті
(текстовий формат)
Файл імпорту – це текстовий файл фіксованої структури, в якому поля розділені окремим символом-
розподілювачем “|” (pipe), з кодуванням windows-1251. Файл імпорту містить блоки даних Загальні
платіжні реквізити, Отримувач, Фактичний Отримувач та Фактичний Платник. Зазначені блоки даних та
поля в цих блоках мають визначені умови використання та обробки. Основними умовами можна
виділити наступне:
1. Блоки Загальні платіжні реквізити та Отримувач завжди є обов’язковими в файлі
2. Блок Фактичний Отримувач є обов’язковим якщо поле наявності Фактичного Отримувача (№28)
має значення «1»
3. Блок Фактичний Платник є обов’язковим якщо поле наявності Фактичного Платника (№44) має
значення «1»
4. Поля даних адреси є обов’язковими, якщо будь-яку поле адреси заповнене, або якщо поле
Пропрієтарного значення має значення «NA» або «TRAN»
5. Поля даних дати та місця народження або поля даних адреси є обов’язковими, якщо поле
Пропрієтарного значення має значення «UNKN»

Опис полів

Тип даних 
------------------------------------------
N       Числовий
F       Логічне значення: 1 або 0
AN      Буквено-цифровий
D       Дата (DD.MM.YYYY)
M       Обов’язкове
O       Необов’язковий (опціональний)
№
Опис

Тип даних
                   Загальні платіжні реквізити
----------------------------------------------------------------
1  N,5        Порядковий номер рядка в файлі (починаючи з 1)
2  AN,29,M    Номер рахунку Платника
3  AN,35,O    Унікальний ідентифікатор (номер) платіжної інструкції
4  D,O        Дата валютування платіжної інструкції. Поточна дата, якщо поле незаповнене
5  N,16+2,M   Сума коштів переказу
6  AN,420,M   Призначення платіжної інструкції на переказ коштів, неструктурована форма
7  AN,40,M    Поле ПДВ

                    Отримувач
----------------------------------------------------------------
8  AN,34,M    Номер рахунку Отримувача
9  F,O        Наразі не заповнюється
10 AN,29,O    Наразі не заповнюється
11 AN,140,M   Найменування
12 N,3,M      Країна резидентності (ISO 3166-1 числовий)
13 AN,8,M     Пропрієтарне (власне) значення:
              для юридичних осіб - USCR, TRAN, NA
              для фізичних осіб - RNRCT, PSPT, OT, UNKN

14 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN
15 AN,140,O  Ім’я контактної особи, за яким можна ідентифікувати учасника
16 AN,14,O   Номер телефону контактної особи, в форматі +380-ХХХХХХХХХ

                     Дані адреси Отримувача (Місцезнаходження)
-------------------------------------------------------------------
17 AN,70,O   Вулиця
18 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
19 AN,70,O   Номер квартири або офісу
20 AN,16,O   Поштовий індекс
21 AN,35,M   Назва населеного пункту
22 AN,35,O   Назва району
23 AN,35,O   Назва області
24 N,3,O     Код країни (ISO 3166-1 числовий)

                  Дата і місце народження Отримувача
------------------------------------------------------------
25 D,M       Дата народження
26 AN,35,M   Населений пункт, в якому народилася особа
27 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                     Фактичний Отримувач
------------------------------------------------------------
28 F,O       0 або незаповнене – Фактичний Отримувач відсутній;
             1 – Фактичний Отримувач присутній, поля Фактичного Отримувача обов’язкові
29 AN,140,M  Найменування
30 N,3,M     Країна резидентності (ISO 3166-1 числовий)
31 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
32 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

            Дані адреси Фактичного Отримувача (Місцезнаходження)
-------------------------------------------------------------------
33 AN,70,O   Вулиця
34 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
35 AN,70,O   Номер квартири або офісу
36 AN,16,O   Поштовий індекс
37 AN,35,M   Назва населеного пункту
38 AN,35,O   Назва району
39 AN,35,O   Назва області
40 N,3,O     Код країни (ISO 3166-1 числовий)

             Дата і місце народження Фактичного Отримувача
-----------------------------------------------------------
41 D,M       Дата народження
42 AN,35,M   Населений пункт, в якому народилася особа
43 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                       Фактичний Платник
------------------------------------------------------------
44 F,O       0 або незаповнене – Фактичний Платник відсутній;
             1 – Фактичний Платник присутній, поля Фактичного Платника обов’язкові
45 AN,140,M  Найменування
46 N,3,M     Країна резидентності (ISO 3166-1 числовий)
47 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
48 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

             Дані адреси Фактичного Платника (Місцезнаходження)
-------------------------------------------------------------------
49 AN,70,O   Вулиця
50 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
51 AN,70,O   Номер квартири або офісу
52 AN,16,O   Поштовий індекс
53 AN,35,M   Назва населеного пункту
54 AN,35,O   Назва району
55 AN,35,O   Назва області
56 N,3,O     Код країни (ISO 3166-1 числовий)

            Дата і місце народження Фактичного Платника
--------------------------------------------------------------------
57 D,M       Дата народження
58 AN,35,M   Населений пункт, в якому народилася особа
59 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)









Экспорт для подсистемы "CORPEX"  !!!!! старый формат !!!!!

1   N,3    Line number in file    Номер рядка в файлі (починаючи з 1)
           (starting from 1) 
2   N/A    Field is empty         Не заповнюється
3   N,6    Sender`s Bank code     Код банку відправника (може бути порожнім)
           (could be empty)
4   AN,29  Sender‘s Account       Рахунок відправника
5   N,10   Sender`s ZKPO code     ЄДРПОУ відправника
6   N,6    Partner Bank Code      Код банку отримувача (може бути порожнім) 
           (could be empty)
7   AN,29  Partner Account        Рахунок отримувача
8   N,10   Partner ZKPO code      ЄДРПОУ отримувача
9   D      Payment Date           Дата платіжного доручення
10  AN,10  Payment Number         Номер платіжного доручення
11  AN,38  Sender`s Name          Назва відправника
12  AN,38  Partner Name           Назва отримувача
13  N,16+2 Amount                 Сума
14  N/A    Field is empty         Не заповнюється
15  N/A    Field is empty         Не заповнюється
16  AN,120 Details                Призначення платежу
17  AN,40  Value added tax field  Інформація про ПДВ
18  N,1    TaxNumber flag (0 or   Ознака наявність коду РНОКПП отримувача. Може бути незаповненим (значення “0”)
           1). Could be empty
           (means 0)
19  AN,2   Passport Series.       Серія паспорту.
           Mandatory when         Заповнюється, якщо
           TaxNumber flag is “1”  ознака наявності коду
                                  РНОКПП дорівнює “1”
20  N,6    Passport Number.       Номер паспорту.
           Mandatory when         Заповнюється, якщо
           TaxNumber flag is “1”  ознака наявності коду



         !!!!!!!!!!!   Новый формат    !!!!!!!!!!!!!!!!!!


Імпорт платіжної інструкції в національній валюті
(текстовий формат)
Файл імпорту – це текстовий файл фіксованої структури, в якому поля розділені окремим символом-
розподілювачем “|” (pipe), з кодуванням windows-1251. Файл імпорту містить блоки даних Загальні
платіжні реквізити, Отримувач, Фактичний Отримувач та Фактичний Платник. Зазначені блоки даних та
поля в цих блоках мають визначені умови використання та обробки. Основними умовами можна
виділити наступне:
1. Блоки Загальні платіжні реквізити та Отримувач завжди є обов’язковими в файлі
2. Блок Фактичний Отримувач є обов’язковим якщо поле наявності Фактичного Отримувача (№28)
має значення «1»
3. Блок Фактичний Платник є обов’язковим якщо поле наявності Фактичного Платника (№44) має
значення «1»
4. Поля даних адреси є обов’язковими, якщо будь-яку поле адреси заповнене, або якщо поле
Пропрієтарного значення має значення «NA» або «TRAN»
5. Поля даних дати та місця народження або поля даних адреси є обов’язковими, якщо поле
Пропрієтарного значення має значення «UNKN»

Опис полів

Тип даних 
------------------------------------------
N       Числовий
F       Логічне значення: 1 або 0
AN      Буквено-цифровий
D       Дата (DD.MM.YYYY)
M       Обов’язкове
O       Необов’язковий (опціональний)
№
Опис

Тип даних
                   Загальні платіжні реквізити
----------------------------------------------------------------
1  N,5        Порядковий номер рядка в файлі (починаючи з 1)
2  AN,29,M    Номер рахунку Платника
3  AN,35,O    Унікальний ідентифікатор (номер) платіжної інструкції
4  D,O        Дата валютування платіжної інструкції. Поточна дата, якщо поле незаповнене
5  N,16+2,M   Сума коштів переказу
6  AN,420,M   Призначення платіжної інструкції на переказ коштів, неструктурована форма
7  AN,40,M    Поле ПДВ

                    Отримувач
----------------------------------------------------------------
8  AN,34,M    Номер рахунку Отримувача
9  F,O        Наразі не заповнюється
10 AN,29,O    Наразі не заповнюється
11 AN,140,M   Найменування
12 N,3,M      Країна резидентності (ISO 3166-1 числовий)
13 AN,8,M     Пропрієтарне (власне) значення:
              для юридичних осіб - USCR, TRAN, NA
              для фізичних осіб - RNRCT, PSPT, OT, UNKN

14 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN
15 AN,140,O  Ім’я контактної особи, за яким можна ідентифікувати учасника
16 AN,14,O   Номер телефону контактної особи, в форматі +380-ХХХХХХХХХ

                     Дані адреси Отримувача (Місцезнаходження)
-------------------------------------------------------------------
17 AN,70,O   Вулиця
18 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
19 AN,70,O   Номер квартири або офісу
20 AN,16,O   Поштовий індекс
21 AN,35,M   Назва населеного пункту
22 AN,35,O   Назва району
23 AN,35,O   Назва області
24 N,3,O     Код країни (ISO 3166-1 числовий)

                  Дата і місце народження Отримувача
------------------------------------------------------------
25 D,M       Дата народження
26 AN,35,M   Населений пункт, в якому народилася особа
27 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                     Фактичний Отримувач
------------------------------------------------------------
28 F,O       0 або незаповнене – Фактичний Отримувач відсутній;
             1 – Фактичний Отримувач присутній, поля Фактичного Отримувача обов’язкові
29 AN,140,M  Найменування
30 N,3,M     Країна резидентності (ISO 3166-1 числовий)
31 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
32 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

            Дані адреси Фактичного Отримувача (Місцезнаходження)
-------------------------------------------------------------------
33 AN,70,O   Вулиця
34 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
35 AN,70,O   Номер квартири або офісу
36 AN,16,O   Поштовий індекс
37 AN,35,M   Назва населеного пункту
38 AN,35,O   Назва району
39 AN,35,O   Назва області
40 N,3,O     Код країни (ISO 3166-1 числовий)

             Дата і місце народження Фактичного Отримувача
-----------------------------------------------------------
41 D,M       Дата народження
42 AN,35,M   Населений пункт, в якому народилася особа
43 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)

                       Фактичний Платник
------------------------------------------------------------
44 F,O       0 або незаповнене – Фактичний Платник відсутній;
             1 – Фактичний Платник присутній, поля Фактичного Платника обов’язкові
45 AN,140,M  Найменування
46 N,3,M     Країна резидентності (ISO 3166-1 числовий)
47 AN,8,M    Пропрієтарне (власне) значення:
             для юридичних осіб - USCR, TRAN, NA
             для фізичних осіб - RNRCT, PSPT, OT, UNKN
48 AN,35,M   Код ідентифікації. Заповнюється значенням:
             000000000 , якщо CREDITORIDTYPE = NA
             99999 , якщо CREDITORIDTYPE = UNKN

             Дані адреси Фактичного Платника (Місцезнаходження)
-------------------------------------------------------------------
49 AN,70,O   Вулиця
50 AN,16,M   Номер будівлі, якщо відсутній вказати «б/н»
51 AN,70,O   Номер квартири або офісу
52 AN,16,O   Поштовий індекс
53 AN,35,M   Назва населеного пункту
54 AN,35,O   Назва району
55 AN,35,O   Назва області
56 N,3,O     Код країни (ISO 3166-1 числовий)

            Дата і місце народження Фактичного Платника
--------------------------------------------------------------------
57 D,M       Дата народження
58 AN,35,M   Населений пункт, в якому народилася особа
59 N,3,M     Країна, де народилася особа, код (ISO 3166-1 числовий)


*/

#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int b_corpex_csv(const char *tabl) /*выгрузка в csv файл*/
{
char		imaf1[64];
class iceb_tu_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }

sprintf(imaf1,"plat.txt");

class iceb_fopen fil_ff;
if(fil_ff.start(imaf1,"w") != 0)
 return(1);

class iceb_tu_str metka_fop("");

int nomer_str=0;

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);

  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  class iceb_tu_str naior(rec.naior.ravno());
  class iceb_tu_str naior1(rec.naior1.ravno());

  if(iceb_tu_strlen(rec.naior.ravno()) > 140)
   {
    naior.new_plus(iceb_t_get_pnk(rec.kodor.ravno(),0));

    sprintf(strsql,"%s %s %s\n%s %s",
    gettext("Наименование контрагента"),
    rec.naior.ravno(),
    gettext("больше 140 символов"),
    gettext("заменили на короткое"),
    naior.ravno());

    iceb_t_soob(strsql);

   }


  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_tu_okrug(rec.sumd,0.01);
/****************************
  fprintf(fil_ff.ff,"%d|||%s|%s||%s|%s|%02d.%02d.%d|%s|%.*s|%.*s|%.2f|||%.*s|%.2f||||\r\n",
  ++nomer_str,
  rec.nsh.ravno(),
  rec.kod.ravno(),
  rec.nsh1.ravno(),
  rec.kod1.ravno(),
  rec.dd,rec.md,rec.gd,
  rec.nomdk.ravno(),
  iceb_tu_kolbait(38,naior.ravno()),
  naior.ravno(),
  iceb_tu_kolbait(38,naior1.ravno()),
  naior1.ravno(),
  rec.sumd,
  iceb_tu_kolbait(120,koment.ravno()),
  koment.ravno(),
  rec.nds);
************************/
  if(iceb_tu_strlen(rec.kod1.ravno()) <= 8)
   metka_fop.new_plus("USRC"); /*юридическое лицо*/
  else
   metka_fop.new_plus("RNRCT"); /*физическое лицо*/
   
  
  fprintf(fil_ff.ff,"%d|%.29s|%.35s|%02d.%02d.%04d|%.2f|%.*s|%.2f|\
%.34s|||%.*s|%.3s|%.8s|%.35s|||\
||||||||\
|||\
0|||||\
||||||||\
|||\
0||||\
||||||||\
|||\r\n",
  ++nomer_str,
  rec.nsh.ravno(),
  rec.nomdk.ravno(),  
  rec.dd,rec.md,rec.gd,
  rec.sumd,
  iceb_tu_kolbait(420,koment.ravno()),
  koment.ravno(),
  rec.nds,      
  rec.nsh1.ravno(),
  iceb_tu_kolbait(140,naior1.ravno()),
  naior1.ravno(),
  "804",
  metka_fop.ravno(),
  rec.kod1.ravno());
    
 }

fil_ff.end();

iceb_t_perecod(2,imaf1);

return(0);
}
 