/*$Id:$*/
/*06.04.2023	02.02.2022	Белых А.И.	b_CorpLight_csv.cpp
Платёжка в формате csv

Экспорт для подсистемы "CorpLight" 



 1 ndoc    Номер платёжного поручения Значение может содержать число и буквы
 2 dt      Дата документа дд.мм.рррр
 3 dv      *** Дата валютирования дд.мм.рррр Если поле пустое, то дата валютирования соотвецтвует дате документа
 4 acccli  Счёт (IBAN) плательщика
 5 acccor  Счёт (IBAN) получателя
 6 okpocor Налоговый код получетеля (ІПН, ЄДРПОУ, ЗКПО) Числовое значение
 7 namecor Наименование получателя Текст
 8 summa   Сумма платежа в копейках
 9 val     Валюта, ISO 4217 Числовий код валюти з довідника (якщо код не 980 – код країни не є обов’язковим до заповнення)	
10 nazn    Назначение платежа не более 160 символов
11 cod_cor ** Код страны нерезидента получателя(ISO 3166-1 numeric)
12 add_req * Дополнительные реквизиты Может содержать буквы или числа

* обов'язково якщо п.6 (податковий код) дорівнює 0000000000

** обов'язково якщо п.6 (податковий код) дорівнює 00000000

*** якщо поле пусте, то дата валютування відповідатиме даті документу.


*/

#include        <errno.h>
#include        <math.h>
#include        "buhg.h"
#include        "dok4.h"

extern class REC rec;

int b_CorpLight_csv(const char *tabl) /*выгрузка в csv файл*/
{
char		imaf1[64];
FILE		*ff1;
class iceb_tu_str koment("");
char		strsql[512];
short		d,m,g;

int kolstr=0;
SQL_str row;
class SQLCURSOR cur;

sprintf(strsql,"select datd,nomd from %s where vidpl='1'",tabl);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return(1);
 }

if(kolstr == 0)
 {
  iceb_t_soob(gettext("Не найдено ни одного документа для передачи в банк!"));
  return(1);
 }


sprintf(imaf1,"plat.txt");
if((ff1 = fopen(imaf1,"w")) == NULL)
 {
  error_op_nfil(imaf1,errno,__FUNCTION__);
  return(1);
 }

double suma_double=0.;
int suma_int=0;
double bb=0.;

fprintf(ff1,"\
ndoc;dt;dv;acccli;acccor;okpocor;namecor;summa;val;nazn;cod_cor;add_req\n");

while(cur.read_cursor(&row) != 0)
 {
  iceb_tu_rsdat(&d,&m,&g,row[0],2);

  if(readpdok(tabl,g,row[1]) != 0)
     continue;

  /*Читаем комментарий*/
  readkom(tabl,rec.dd,rec.md,rec.gd,rec.nomdk.ravno(),&koment);

  //Округляем, чтобы не пропадали копейки
  rec.sumd=iceb_tu_okrug(rec.sumd,0.01);

  bb=rec.sumd*100.;
 
  modf(bb,&suma_double);
  suma_int=(int)suma_double;


  fprintf(ff1,"%s;%02d.%02d.%4d;;%s;%s;%s;%s;%d;%s;\"%s\";%s;\r\n",
  rec.nomdk.ravno(),
  rec.dd,rec.md,rec.gd,
  rec.nsh.ravno(),
  rec.nsh1.ravno(),
  rec.kod1.ravno(),
  rec.naior1.ravno(),
  suma_int,
  "980",
  koment.ravno(),
  "804");      

 }

fclose(ff1);

return(0);
}
 