/*$Id:$*/
/*24.05.2023	27.11.2016	Белых А.И.	fort_anz1.c
Работа с нарядом
*/

#include <buhl.h>
#include "fort.h"

void fort_anz1_h(short mn,short gn,const char *nn,int podr,double otr_vrem,double sumapn);
int fort_anz1_vvod(int metka_r,short mn,short gn,const char *nn,int podr,int nz);
int fort_anz1_vvod1(int metka_r,short mn,short gn,const char *nn,int podr,int nz);
int fort_anz1_zap(int metka_r,short mn,short gn,const char *nn,int nz,int podr,class VVOD *VV);
void fort_anz1_ras(SQLCURSOR *cur,short mn,short gn,const char *nn,int podr,int kolstr);

int metka_vvoda=0; /*0-расширенный ввод 1-сокращённый*/

void fort_anz1(short mn,short gn,const char *nn,int podr)
{
char		strsql[1024];
class iceb_t_mstr spis_menu(0);
SQL_str		row;
class SQLCURSOR cur;
class iceb_tu_str datavz(""); /*дата выдачи замовлення*/
class iceb_tu_str datavp(""); /*дата выполнения*/
short mes_nar=mn;
short god_nar=gn;
class iceb_tu_str nom_nar(nn);

int		kolstr=0;
int		K=0;
int		pozz=0,pozz1=0;
int		i=0,kom=0;
int		mspz=0;
int		prc;
int             Y=3;
int             X=0;

double suma_vremeni=0.;
double suma=0.;
double otr_vrem=0.;
double sumapn=0.;

class VVOD DANET(1);


naz1:;

short           kls=LINES-6;
int nom_zap[kls];

sprintf(strsql,"select * from Fortzn1 where datan = '%04d-%02d-01' and nn='%s' and pd=%d order by vpz asc",
god_nar,mes_nar,nom_nar.ravno(),podr);

if((kolstr=cur.make_cursor(&bd,strsql)) < 0)
 {
  iceb_t_msql_error(&bd,gettext("Ошибка создания курсора !"),strsql);
  return;
 }



if(kolstr == 0)
 {
lll:;


  fort_anz1_h(mes_nar,god_nar,nom_nar.ravno(),podr,0.,0.);
  
  VVOD SOOB(1);
  SOOB.VVOD_spisok_add_MD(gettext("Не найдено ни одной записи !"));
  K=soobshw(&SOOB,stdscr,-1,-1,1,1);

  if(K == SFK2 || K == ENTER || K == FK3 || K == FK5)
    goto lll;

  if(K == KEY_RESIZE)
   goto naz1;   

  goto vper;
 }
 else
  {
   otr_vrem=sumapn=0.;
   /*вычисляем суммы по наряду*/
   while(cur.read_cursor(&row) != 0)
    {
     otr_vrem+=atof(row[12])*atof(row[15]);
     sumapn+=atof(row[13])*atof(row[15]);
    }
  }

if(kolstr != 0 && pozz > kolstr)
  pozz = kolstr-1;

naz:;

cur.poz_cursor(pozz);
mspz=2;
pozz1=0;

spis_menu.spis_str.free_class();
for(i=0;i<=kls-1;)
 {
  if(cur.read_cursor(&row) == 0)
    break;
  pozz1++;
  
  nom_zap[i]=atoi(row[0]);
  datavz.new_plus(iceb_tu_datzap(row[4]));
  datavp.new_plus(iceb_tu_datzap(row[8]));
   	
//  if(fort_an_prov(row,&rp) != 0)
//   continue;
  suma_vremeni=atof(row[12])*atof(row[15]);
  suma=atof(row[13])*atof(row[15]);


  sprintf(strsql,"%10s|%-5s|%-*.*s|%-*.*s|%5.5g|%10s|%-3s|%2s|%6.6g|%6.6g|%2s|%6.6g|%10.3f|%10.2f",
  datavz.ravno(),
  row[10],
  iceb_tu_kolbait(20,row[5]),
  iceb_tu_kolbait(20,row[5]),
  row[5],
  iceb_tu_kolbait(5,row[6]),
  iceb_tu_kolbait(5,row[6]),
  row[6],
  atof(row[7]),
  datavp.ravno(),
  row[9],
  row[11],
  atof(row[12]),
  atof(row[13]),
  row[14],
  atof(row[15]),  
  suma_vremeni,
  suma);

  spis_menu.spis_str.plus(strsql);
  i++;
  
  if(pozz1 == 1) /*Первая запись удовлетворяет условиям поиска*/
   mspz=1;

 }

if(i == 0)
 {
  if(kolstr != 0 && pozz > 0)
   {
    pozz--;
    goto naz;
   }
  goto lll;
 }  
if(kom >= i)
  kom=i-1;

if(kom < 0)
 kom=0;

if(i <=kls-1)
  spis_menu.spis_str.plus(gettext("Конец списка"));


fort_anz1_h(mes_nar,god_nar,nom_nar.ravno(),podr,otr_vrem,sumapn);

prc=(pozz+pozz1)*100/kolstr;
memset(strsql,'\0',sizeof(strsql));
kom=spis_menu.menu(kom,Y,X,NULL,strsql,prc,&K,"",COLS-25);


if(kom == -7) //Изменение границы экрана
  goto naz1;

if(kom == -3) /*Стрелка вниз*/
 {
  if(i <kls)
   {
    beep();
    goto naz;
   }
  for(i=0; i< mspz   ; )
   {
    pozz++;
    if(pozz >= kolstr)
     {
      pozz=kolstr-1;
      break;
     }
    cur.poz_cursor(pozz);
    if(cur.read_cursor(&row) == 0)
      break;
//    if(fort_an_prov(row,&rp) != 0)
//     continue;
    i++;
   }
  kom=kls-1;
  goto naz;
 }
if(kom == -2) /*Стрелка вверх*/
 {
  for(i=0; i < 1 ; )
   {

    pozz--;

    if(pozz <= 0)
     {
      beep();
      pozz=0;
      goto naz;
     }

    cur.poz_cursor(pozz);
    cur.read_cursor(&row);
//    if(fort_an_prov(row,&rp) != 0)
//     continue;
    i++;
   }

  goto naz;
 }
 
if(kom == -5) /*Страница вниз*/
 {
  if(pozz + kls == kolstr)
   {
    pozz=kolstr-1;
    beep();
    goto naz;  
   }
  if(i == kls)
    pozz+=pozz1;
  else
    beep();
  if(pozz >= kolstr)
   {
    pozz=kolstr-pozz1;
    beep();
    goto naz;  
   }
  goto naz;

 }

if(kom == -4) /*Страница вверх*/
 {
  for(i=0; i<kls ; )
   {
    pozz--;

    if(pozz <= 0)
     {
      beep();
      pozz=0;
      goto naz;
     }

    cur.poz_cursor(pozz);
    if(cur.read_cursor(&row) == 0)
      break;
//    if(fort_an_prov(row,&rp) != 0)
//     continue;
    i++;
   }
  goto naz;
 }

if(kom >= 0)
 {
  class iceb_tu_str str_vib(spis_menu.spis_str.ravno(kom));
  if(iceb_tu_SRAV(gettext("Конец списка"),str_vib.ravno(),0) == 0)
     goto naz;
  if(pozz+kom >= kolstr)
   goto naz; /*Стали на конец списка*/

 }

vper:;

switch (K)
 {
  case FK10: /*Выход*/
  case ESC : /*Выход*/
     return;

  case FK1:  /*Получить подсказку*/
    GDITE();
//    iceb_t_pdoc("matu4_6.txt");
    goto naz;

  case SFK1:  /*работать с шапкой документа*/
   
    fort_vhn(&mes_nar,&god_nar,&nom_nar,&podr);
    goto naz1;

  case ENTER:
  case SFK2:   /*Корректировать*/
    if(metka_vvoda == 0)
     fort_anz1_vvod(1,mes_nar,god_nar,nom_nar.ravno(),podr,nom_zap[kom]);
    else
     fort_anz1_vvod1(1,mes_nar,god_nar,nom_nar.ravno(),podr,nom_zap[kom]);
    goto naz1;

  case FK2:  /*Ввести запись*/
  case PLU:
    if(metka_vvoda == 0)
     fort_anz1_vvod(0,mes_nar,god_nar,nom_nar.ravno(),podr,nom_zap[kom]);
    else
     fort_anz1_vvod1(0,mes_nar,god_nar,nom_nar.ravno(),podr,nom_zap[kom]);
     
    goto naz1;


  case FK3: /*удалить запись*/
    DANET.VVOD_delete();
    DANET.VVOD_spisok_add_MD(gettext("Удалить ? Вы уверены ?"));

    if(danet(&DANET,2,stdscr) == 1)
     {
      sprintf(strsql,"delete from Fortzn1 where nz=%d",nom_zap[kom]);
      if(iceb_t_sql_zapis(strsql,0,0) == 0)
        goto naz1;
     }
    goto naz;

  case SFK3: /*удалить запись*/
    DANET.VVOD_delete();
    DANET.VVOD_spisok_add_MD(gettext("Удалить наряд ? Вы уверены ?"));

    if(danet(&DANET,2,stdscr) == 1)
     {
      sprintf(strsql,"delete from Fortzn1 where datan='%04d-%02d-01' and nn='%s' and pd=%d",god_nar,mes_nar,nom_nar.ravno(),podr);
      if(iceb_t_sql_zapis(strsql,0,0) == 0)
       {
        
        sprintf(strsql,"delete from Forthn where datan='%04d-%02d-01' and nn='%s' and pd=%d",god_nar,mes_nar,nom_nar.ravno(),podr);
        if(iceb_t_sql_zapis(strsql,0,0) == 0)
          return;
       }
     }
    goto naz;
 
  case FK4:       /*Поиск*/

     clear();
     kom=pozz=0;
     goto naz1;

  case FK5:    //Распечатать
    fort_anz1_ras(&cur,mes_nar,god_nar,nom_nar.ravno(),podr,kolstr);
    goto naz;

  case FK6:    //метка ввода
    metka_vvoda++;
    if(metka_vvoda > 1)
     metka_vvoda=0;
    goto naz1;


  default:
    goto naz;
    break;
 }


}
/********************************/
/*шапка*/
/**********************/
void fort_anz1_h(short mn,short gn,const char *nn,int podr,double otr_vrem,double sumapn)
{
short		y=2;
short           x=COLS-20;
clear();

printw("%s:%02d.%d %s:%d %s:%s\n%s:%.3f %s %s:%.2f грн.\n",
gettext("Дата"),
mn,gn,
"Підрозділ",
podr,
gettext("Наряд"),
nn,
"Відпрацьовано часу",
otr_vrem,
gettext("мин."),
"Сума",
sumapn/100.);


mvprintw(2,0,"     1         2            3             4     5       6       7   8   9      10    11   12       13        14");

mvprintw(y++,x,gettext("Наименование полей:"));

mvprintw(y++,x,"1-%s","дата видачі");
mvprintw(y++,x,"2-%s","шифр витрат");
mvprintw(y++,x,"3-%s","най-вання деталі");
mvprintw(y++,x,"4-%s","най-вання операції");
mvprintw(y++,x,"5-%s","задана кількість");
mvprintw(y++,x,"6-%s","термін виконання");
mvprintw(y++,x,"7-%s","розряд");

mvprintw(y++,x,"8-%s","тарифна сітка");
mvprintw(y++,x,"9-%s","норма часу");
mvprintw(y++,x,"10-%s","розцінка");
mvprintw(y++,x,"11-%s","код операції");
mvprintw(y++,x,"12-%s","кількість");
mvprintw(y++,x,"13-%s","відпр. часу");
mvprintw(y++,x,"14-%s","сума");




helstr(LINES-1,0,"Enter",gettext("корректировка"),
"F2/+",gettext("новая запись"),
"F3",gettext("удалить"),
"F5",gettext("печать"),
"F6",gettext("ввод"),
"F10",gettext("выход"),NULL);


}
/**************************************/
/*ввод и корректировка записи*/
/**************************************/
int fort_anz1_vvod(int metka_r,/*0-ввод новой записи 1-корректировка уже введённой*/
short mn,short gn,const char *nn,int podr,int nz)
{
int N=0;
int K=0;
char strsql[1024];
class VVOD VV(0);



VV.VVOD_spisok_add_data(10);  //0 Дата видачі замовлення
VV.VVOD_spisok_add_data(8);   //1  Шифр витрат
VV.VVOD_spisok_add_data(128); //2 Найменування детали
VV.VVOD_spisok_add_data(128); //3 Найменування операції
VV.VVOD_spisok_add_data(20);  //4  Задана кількість
VV.VVOD_spisok_add_data(10);  //5 Термін виконання
VV.VVOD_spisok_add_data(12);  //6 Розряд

VV.VVOD_spisok_add_data(5);   //7 таріфна сітка
VV.VVOD_spisok_add_data(20);  //8 норма часу
VV.VVOD_spisok_add_data(20);  //9 розцінка
VV.VVOD_spisok_add_data(10);  //10 код операції
VV.VVOD_spisok_add_data(10);  //11 кількість



if(metka_r != 0)
 {
  SQL_str row;
  class SQLCURSOR cur;
  
  sprintf(strsql,"select * from Fortzn1 where nz=%d",nz);
  if(sql_readkey(&bd,strsql,&row,&cur) != 1)
   {
    printw("\n%s\n",strsql);
    iceb_t_soob(gettext("Не найдена запись для корректировки!"));
    return(1);   
   }


  VV.VVOD_spisok_zapis_data(0,iceb_tu_datzap(row[4]));
  VV.VVOD_spisok_zapis_data(1,row[10]);
  VV.VVOD_spisok_zapis_data(2,row[5]);
  VV.VVOD_spisok_zapis_data(3,row[6]);
  VV.VVOD_spisok_zapis_data(4,row[7]);
  VV.VVOD_spisok_zapis_data(5,iceb_tu_datzap(row[8]));
  VV.VVOD_spisok_zapis_data(6,row[9]);
  VV.VVOD_spisok_zapis_data(7,row[11]);

  sprintf(strsql,"%.3g",atof(row[12]));
  VV.VVOD_spisok_zapis_data(8,strsql);

  sprintf(strsql,"%.3g",atof(row[13]));
  VV.VVOD_spisok_zapis_data(9,strsql);

  VV.VVOD_spisok_zapis_data(10,row[14]);

  sprintf(strsql,"%.3g",atof(row[15]));
  VV.VVOD_spisok_zapis_data(11,strsql);



  VV.VVOD_spisok_add_ZAG(gettext("Корректировка записи"));
  kzvz(atoi(row[16]),atol(row[17]),&VV);
     
 }
else
 {
  VV.VVOD_spisok_add_ZAG(gettext("Ввод новой записи"));
 }



VV.VVOD_spisok_add_MD("Дата видачи замовлення.(д.м.р).");//0
VV.VVOD_spisok_add_MD("Шифр витрат....................");//1
VV.VVOD_spisok_add_MD("Найменування деталі............");//2
VV.VVOD_spisok_add_MD("Найменування операції..........");//3
VV.VVOD_spisok_add_MD("Задана кількість...............");//4
VV.VVOD_spisok_add_MD("Термін виконання.......(д.м.р).");//5
VV.VVOD_spisok_add_MD("Розряд.........................");//6
VV.VVOD_spisok_add_MD("Тарифна сітка..................");//7
VV.VVOD_spisok_add_MD("Норма часу (мінути)............");//8
VV.VVOD_spisok_add_MD("Розцінка (копійки).............");//9
VV.VVOD_spisok_add_MD("Код операції...................");//10
VV.VVOD_spisok_add_MD("Кількість (штуки)..............");//11


naz:;


helstr(LINES-1,0,
//"F1","допомога"),
"F2/+",gettext("запись"),
//"F3",gettext("реквизиты"),
"F10",gettext("виход"),NULL);

VV.vramka(-1,-1,0);

for(;;)
 {

  attron(VV.VVOD_return_cs(iceb_CFS)); 

  VV.vprintw(N,stdscr);
  
  K=getch();


  attroff(VV.VVOD_return_cs(iceb_CFS));
  attron(VV.VVOD_return_cs(iceb_CFM));

  VV.vprintw(N,stdscr);

  if(K == KEY_RESIZE)
    goto naz;


  if(K == KEY_MOUSE)
    K=mouseklic(&N,VV.PY,VV.PX,VV.MDLS,VV.KLST,stdscr);

   
  if(K == ENTER)
   {
    attroff(VV.VVOD_return_cs(iceb_CFM));
    attron(VV.VVOD_return_cs(iceb_CFV));
    VV.vprintw_clear(N,stdscr);

    VV.vgetstr(N,stdscr);
    
    attroff(VV.VVOD_return_cs(iceb_CFV));
    attron(VV.VVOD_return_cs(iceb_CFM));

    if(N == 1 && VV.VVOD_spisok_return_data(N)[0] != '\0')
     {
     }

    if(N == 5 && VV.VVOD_spisok_return_data(N)[0] != '\0')
     {
     }

    attroff(VV.VVOD_return_cs(iceb_CFV));
    attron(VV.VVOD_return_cs(iceb_CFM));

    VV.vprintw(N,stdscr);
    N++;
   }
  if(K==SDN) /*Стрелка вниз*/
   {
    N++;
   }
  if(K==SUP) /*Стрелка вверх*/
   {
    N--;
   }
  if(N > VV.KLST-1)
   {
    N=0;
   }
  if(N < 0)
   {
    N=VV.KLST-1;
   }

  if(K == ESC || K == FK10)
   {
    attroff(VV.VVOD_return_cs(iceb_CFS));
    attron(VV.VVOD_return_cs(iceb_CFM));
    N=-1;
    break;
   }

  if(K == FK1) //Помощь
   {
    attroff(VV.VVOD_return_cs(iceb_CFS));
    GDITE();
//    iceb_t_prosf(strsql);
    clear();
    goto naz;
   }

  if(K == FK2 || K == PLU) //Записываем
   {
    if(fort_anz1_zap(metka_r,mn,gn,nn,nz,podr,&VV) != 0)
     goto naz;
    break;
   }

 }
attroff(VV.VVOD_return_cs(iceb_CFS));
attron(VV.VVOD_return_cs(iceb_CB));
clear();
refresh();
return(0);


return(0);
}
/**************************/
/*Запись*/
/*****************************/
int fort_anz1_zap(int metka_r,/*0-ввод новой записи 1-корректировка уже введённой*/
short mn,short gn,const char *nn,int nz,int podr,class VVOD *VV)
{
char strsql[1024];
short dvz=0,mvz=0,gvz=0;
short dvp=0,mvp=0,gvp=0;

if(VV->data_ravno(0)[0] != '\0')
if(iceb_tu_rsdat(&dvz,&mvz,&gvz,VV->data_ravno(0),0) != 0)
 {
  iceb_t_soob("Не вірно введена дата видачі замовлення!");
  return(1);
 }
if(VV->data_ravno(5)[0] != '\0')
if(iceb_tu_rsdat(&dvp,&mvp,&gvp,VV->data_ravno(5),0) != 0)
 {
  iceb_t_soob("Не вірно введена дата виконання!");
  return(1);
 }



if(metka_r == 1) /*корректировка записи*/
 {
  sprintf(strsql,"update Fortzn1 set \
datavz='%04d-%02d-%02d',\
nd='%s',\
no='%s',\
zkol=%.3f,\
datavp='%04d-%02d-%02d',\
rz='%s',\
hz='%s',\
ts=%d,\
nv=%.3f,\
rc=%.3f,\
ko=%d,\
kol=%.2f,\
ktoz=%d,\
vrem=%ld \
where nz=%d",
  gvz,mvz,dvz,
  VV->data_ravno_filtr(2),
  VV->data_ravno_filtr(3),
  VV->data_ravno_atof(4),
  gvp,mvp,dvp,
  VV->data_ravno_filtr(6),
  VV->data_ravno_filtr(1),
  VV->data_ravno_atoi(7),
  VV->data_ravno_atof(8),
  VV->data_ravno_atof(9),
  VV->data_ravno_atoi(10),
  VV->data_ravno_atof(11),
  iceb_t_getuid(),
  time(NULL),
  nz);
 }
else /*ввод новой записи*/
 {
  sprintf(strsql,"insert into Fortzn1 (\
datan,\
nn,\
pd,\
datavz,\
nd,\
no,\
zkol,\
datavp,\
rz,\
hz,\
ts,\
nv,\
rc,\
ko,\
kol,\
ktoz,\
vrem,\
vpz)\
 values(\
'%04d-%02d-01',\
%s,\
%d,\
'%04d-%02d-%02d',\
'%s',\
'%s',\
%.3f,\
'%04d-%02d-%02d',\
'%s',\
'%s',\
%d,\
%.3f,\
%.3f,\
%d,\
%.2f,\
%d,\
%ld,\
%ld)",
  gn,mn,
  nn,
  podr,
  gvz,mvz,dvz,
  VV->data_ravno_filtr(2),
  VV->data_ravno_filtr(3),
  VV->data_ravno_atof(4),
  gvp,mvp,dvp,
  VV->data_ravno_filtr(6),
  VV->data_ravno_filtr(1),
  VV->data_ravno_atoi(7),
  VV->data_ravno_atof(8),
  VV->data_ravno_atof(9),
  VV->data_ravno_atoi(10),
  VV->data_ravno_atof(11),
  iceb_t_getuid(),
  time(NULL),
  time(NULL));

 }

if(iceb_t_sql_zapis(strsql,0,0) != 0)
 return(1);
 
return(0);
}

/**************************************************/
void fort_anz1_hap1(int nomstr,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr+=5;

fprintf(ff,"\
-----------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

fprintf(ff,"\
  Дата    |  Шифр  | Позначення деталі  |Найменування| Задана  |  Термін  |Розряд|Тариф.| Норма |   Розцінка   |Код  |Кількість|  Всього  |   Сума   |  Сума    |\n\
 видачі   | витрат |складальної одиниці |  операції  |кількість|використан|      |сітка | часу  |   копійки    |опер.|  штуки  |норма часу|  гривні  |з коефіці-|\n\
замовлень |        |                    |            |         |    ня    |      |      |хвилини|              |     |         |  хвилини |          |  єнтом   |\n");
/****
1234567890 12345678 12345678901234567890 123456789012 123456789 1234567890 123456 123456 1234567 12345678901234 12345 123456789 1234567890 1234567890 1234567890 
******/
fprintf(ff,"\
-----------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

}
/*********************************************/
void fort_anz1_hap2(int nomstr,int *kolstr,FILE *ff)
{
if(kolstr != NULL)
 *kolstr+=5;

fprintf(ff,"\
----------------------------------------------------------------------------------------\n");
fprintf(ff,"\
  Шифр  |Тариф.| Норма |   Розцінка   |Код  |Кількість|  Всього  |   Сума   |  Сума    |\n\
 витрат |сітка | часу  |   копійки    |опер.|  штуки  |норма часу|  гривні  |з коефіці-|\n\
        |      |хвилини|              |     |         |  хвилини |          |  єнтом   |\n");
/*************
12345678 123456 1234567 12345678901234 12345 123456789 1234567890 1234567890
  
***************/
fprintf(ff,"\
----------------------------------------------------------------------------------------\n");
}


/***********************************/
/*распечатка*/
/**********************************/
void fort_anz1_ras(SQLCURSOR *cur,short mn,short gn,const char *nn,int podr,int kolstr)
{
char	imaf[64],imaf1[64];
SQL_str row;
class SQLCURSOR cur1;
char strsql[1024];

class iceb_tu_spisok hz;      /*шифры затрат*/
class iceb_tu_double vrem; /*время по затратам*/
class iceb_tu_double isum; /*сумма по затратам*/

class iceb_tu_spisok ts_ko; /*список тарифных сеток с кодом операции*/
class iceb_tu_double ts_ko_v; 
class iceb_tu_double ts_ko_s;

class iceb_tu_str zak("");
class iceb_tu_str isp("");
class iceb_tu_str kom("");
float kf=0.;
class iceb_tu_spisok sp_hz;

if(iceb_t_read_spis(&sp_hz,"fort_shz_bk.alx") != 0)
 {
  return;
 }

/*читаем шапку документа*/
sprintf(strsql,"select zak,isp,kom,kf from Forthn where datan='%04d-%02d-01' and nn='%s' and pd=%d",gn,mn,nn,podr);
if(iceb_t_sql_readkey(strsql,&row,&cur1) == 1)
 {
  zak.new_plus(row[0]);
  isp.new_plus(row[1]);
  kom.new_plus(row[2]);
  kf=atof(row[3]);
 }






sprintf(imaf,"nar%d.lst",getpid());
class iceb_fopen nar;
if(nar.start(imaf,"w") != 0)
 return;

sprintf(imaf1,"nar1%d.lst",getpid());
class iceb_fopen nar1;
if(nar1.start(imaf1,"w") != 0)
 return;


sprintf(strsql,"%s:%02d.%d %s %s:%d %s %s",gettext("Дата"),mn,gn,
gettext("г."),
gettext("Подразделение"),
podr,
gettext("Наряд"),
nn);

iceb_t_zagolov(strsql,nar.ff);
iceb_t_zagolov(strsql,nar1.ff);

if(zak.getdlinna() > 1)
 {
  fprintf(nar.ff,"%s:%s\n",gettext("Заказ"),zak.ravno());
  fprintf(nar1.ff,"%s:%s\n",gettext("Заказ"),zak.ravno());
 }
if(isp.getdlinna() > 1)
 { 
  fprintf(nar.ff,"%s:%s\n",gettext("Исполнитель"),isp.ravno());
  fprintf(nar1.ff,"%s:%s\n",gettext("Исполнитель"),isp.ravno());
 }

if(kom.getdlinna() > 1)
 {
  fprintf(nar.ff,"%s:%s\n",gettext("Коментарий"),kom.ravno()); 
  fprintf(nar1.ff,"%s:%s\n",gettext("Коментарий"),kom.ravno()); 
 }

fprintf(nar.ff,"Коефіцієнт:%f\n",kf);
fprintf(nar1.ff,"Коефіцієнт:%f\n",kf);


fort_anz1_hap2(1,NULL,nar.ff);
fort_anz1_hap1(1,NULL,nar1.ff);



class iceb_tu_str datavz("");
class iceb_tu_str datavp("");

cur->poz_cursor(0);
double suma_vremeni=0.;
double suma=0.;
double itogo[3];
memset(itogo,'\0',sizeof(itogo));
int nom_hz=0;
double suma_s_kf=0.;
char metka_kf[2]; /*метка в списке без коэффициета*/
int shet=0;
while(cur->read_cursor(&row) != 0)
 {
  
  itogo[0]+=suma_vremeni=atof(row[12])*atof(row[15]);
  itogo[1]+=suma=atof(row[13])*atof(row[15])/100.;

  suma_s_kf=0.;


  memset(metka_kf,'\0',sizeof(metka_kf));
  if(sp_hz.find(row[10]) >= 0 && kf != 0.) /*шифр есть в списке без коєффициентов*/
   {
    metka_kf[0]='*';
    
    suma_s_kf=atof(row[13])*atof(row[15])/100.;
   }
  else
    suma_s_kf=atof(row[13])*atof(row[15])/100.*kf;

  datavz.new_plus(iceb_tu_datzap(row[4]));
  datavp.new_plus(iceb_tu_datzap(row[8]));

  itogo[2]+=suma_s_kf;
//sprintf(strsql,"select nz,hz,ts,nv,rc,ko,kol,vrem,ktoz from Fortzn where datan = '%04d-%02d-01' and nn='%s' and pd=%d order by vrem asc",
  
  fprintf(nar.ff,"%-8s %6s %7.7g %14.14g %5s %9.9g %10.2f %10.2f %10.2f %s\n",
  row[10],
  row[11],
  atof(row[12]),
  atof(row[13]),
  row[14],
  atof(row[15]),
  suma_vremeni,
  suma,
  suma_s_kf,
  metka_kf);


  fprintf(nar1.ff,"%10s|%-8s|%-*.*s|%-*.*s|%9.9g|%10s|%-6s|%6s|%7.7g|%14.14g|%5s|%9.9g|%10.10g|%10.2f|%10.2f|%s\n",
  datavz.ravno(),
  row[10],
  iceb_tu_kolbait(20,row[5]),
  iceb_tu_kolbait(20,row[5]),
  row[5],
  iceb_tu_kolbait(12,row[6]),
  iceb_tu_kolbait(12,row[6]),
  row[6],
  atof(row[7]),
  datavp.ravno(),
  row[9],  
  row[11],
  atof(row[12]),
  atof(row[13]),
  row[14],
  atof(row[15]),
  suma_vremeni,
  suma,
  suma_s_kf,
  metka_kf);
  shet++;

  if(shet != kolstr)
   fprintf(nar1.ff,"\
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n");

  if((nom_hz=hz.find(row[10])) < 0)
    hz.plus(row[10]);
  vrem.plus(suma_vremeni,nom_hz);
  isum.plus(suma,nom_hz);
  
  
  sprintf(strsql,"%s|%s",row[11],row[14]);
  if((nom_hz=ts_ko.find(strsql)) < 0)
   ts_ko.plus(strsql);
  ts_ko_v.plus(suma_vremeni,nom_hz);
  ts_ko_s.plus(suma,nom_hz);
 }

fprintf(nar1.ff,"ICEB_LST_END\n");
fprintf(nar.ff,"ICEB_LST_END\n");

fprintf(nar.ff,"\
----------------------------------------------------------------------------------------\n");

fprintf(nar.ff,"%*s %10.2f %10.2f %10.2f\n",
iceb_tu_kolbait(54,gettext("Итого")),
gettext("Итого"),
itogo[0],
itogo[1],
itogo[2]);

fprintf(nar1.ff,"\
-----------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
fprintf(nar1.ff,"%*s %10.2f %10.2f %10.2f\n",
iceb_tu_kolbait(127,gettext("Итого")),
gettext("Итого"),
itogo[0],
itogo[1],
itogo[2]);




fprintf(nar.ff,"\n\nПідрозділ %d Наряд %s Дата %02d.%d\n",podr,nn,mn,gn);

fprintf(nar.ff,"\
-------------------------------\n");
fprintf(nar.ff,"\
  Шифр  |Норма часу|   Сума   |\n\
 витрат |  години  |  гривні  |\n");
/******
123456 1234567890 1234567890
*********/
fprintf(nar.ff,"\
-------------------------------\n");
for(int nom=0; nom < hz.kolih(); nom++)
 {
  fprintf(nar.ff,"%8s %10.3f %10.2f\n",
  hz.ravno(nom),
  vrem.ravno(nom)/60.,
  isum.ravno(nom));
 }
fprintf(nar.ff,"\
-------------------------------\n");
fprintf(nar.ff,"%8s %10.3f %10.2f\n","",itogo[0]/60.,itogo[1]);

fprintf(nar.ff,"\n\nПідрозділ %d Наряд %s Дата %02d.%d\n",podr,nn,mn,gn);
fprintf(nar.ff,"\
--------------------------------------\n");
fprintf(nar.ff,"\
Тариф.|  Код   |Норма часу|   Сума   |\n\
сітка |операції|  години  |  гривні  |\n");
 
fprintf(nar.ff,"\
--------------------------------------\n");
class iceb_tu_str ts("");
class iceb_tu_str ko("");

for(int nom=0; nom < ts_ko.kolih(); nom++)
 {
  iceb_tu_polen(ts_ko.ravno(nom),&ts,1,'|');
  iceb_tu_polen(ts_ko.ravno(nom),&ko,2,'|');
    
  fprintf(nar.ff,"%6s %8s %10.3f %10.2f\n",
  ts.ravno(),
  ko.ravno(),
  ts_ko_v.ravno(nom)/60.,
  ts_ko_s.ravno(nom));      
 }
fprintf(nar.ff,"\
--------------------------------------\n");
fprintf(nar.ff,"%15s %10.3f %10.2f\n\n","",itogo[0]/60.,itogo[1]);
 
iceb_t_podpis(nar.ff);
nar.end();

iceb_t_podpis(nar1.ff);
nar1.end();



class spis_oth oth;
oth.spis_imaf.plus(imaf);
oth.spis_naim.plus(gettext("Распечатка наряда"));

oth.spis_imaf.plus(imaf1);
oth.spis_naim.plus(gettext("Распечатка наряда полная"));

iceb_t_ustpeh(oth.spis_imaf.ravno(0),3,&kolstr);
iceb_t_rnl(oth.spis_imaf.ravno(0),kolstr,"",&fort_anz1_hap2);

iceb_t_ustpeh(oth.spis_imaf.ravno(1),3,&kolstr);
iceb_t_rnl(oth.spis_imaf.ravno(1),kolstr,"- - -",&fort_anz1_hap1);

iceb_t_rabfil(&oth,"");

}

/**************************/
/*Запись*/
/*****************************/
int fort_anz1_zap1(int metka_r,/*0-ввод новой записи 1-корректировка уже введённой*/
short mn,short gn,const char *nn,int nz,int podr,class VVOD *VV)
{
char strsql[1024];

if(metka_r == 1) /*корректировка записи*/
 {
  sprintf(strsql,"update Fortzn1 set \
hz='%s',\
ts=%d,\
nv=%.3f,\
rc=%.3f,\
ko=%d,\
kol=%.2f,\
ktoz=%d,\
vrem=%ld \
where nz=%d",
  VV->data_ravno_filtr(0),
  VV->data_ravno_atoi(1),
  VV->data_ravno_atof(2),
  VV->data_ravno_atof(3),
  VV->data_ravno_atoi(4),
  VV->data_ravno_atof(5),
  iceb_t_getuid(),
  time(NULL),
  nz);
 }
else /*ввод новой записи*/
 {
  sprintf(strsql,"insert into Fortzn1 (datan,nn,pd,hz,ts,nv,rc,ko,kol,ktoz,vrem,vpz) values('%04d-%02d-01',%s,%d,'%s',%d,%.3f,%.3f,%d,%.2f,%d,%ld,%ld)",
  gn,mn,
  nn,
  podr,
  VV->data_ravno_filtr(0),
  VV->data_ravno_atoi(1),
  VV->data_ravno_atof(2),
  VV->data_ravno_atof(3),
  VV->data_ravno_atoi(4),
  VV->data_ravno_atof(5),
  iceb_t_getuid(),
  time(NULL),
  time(NULL));

 }

if(iceb_t_sql_zapis(strsql,0,0) != 0)
 return(1);
 
return(0);
}




/**************************************/
/*ввод и корректировка записи 2*/
/**************************************/
int fort_anz1_vvod1(int metka_r,/*0-ввод новой записи 1-корректировка уже введённой*/
short mn,short gn,const char *nn,int podr,int nz)
{
int N=0;
int K=0;
char strsql[1024];
class VVOD VV(0);

VV.VVOD_spisok_add_data(8);//0
VV.VVOD_spisok_add_data(5);//1
VV.VVOD_spisok_add_data(20);//2
VV.VVOD_spisok_add_data(20);//3
VV.VVOD_spisok_add_data(10);//4
VV.VVOD_spisok_add_data(10);//5



if(metka_r != 0)
 {
  SQL_str row;
  class SQLCURSOR cur;
  
  sprintf(strsql,"select hz,ts,nv,rc,ko,kol,ktoz,vrem from Fortzn1 where nz=%d",nz);
  if(sql_readkey(&bd,strsql,&row,&cur) != 1)
   {
    printw("\n%s\n",strsql);
    iceb_t_soob(gettext("Не найдена запись для корректировки!"));
    return(1);   
   }
  VV.VVOD_spisok_zapis_data(0,row[0]);
  VV.VVOD_spisok_zapis_data(1,row[1]);
  VV.VVOD_spisok_zapis_data(2,row[2]);
  VV.VVOD_spisok_zapis_data(3,row[3]);
  VV.VVOD_spisok_zapis_data(4,row[4]);
  VV.VVOD_spisok_zapis_data(5,row[5]);



  VV.VVOD_spisok_add_ZAG(gettext("Корректировка записи"));
  kzvz(atoi(row[6]),atol(row[7]),&VV);
     
 }
else
 {
  VV.VVOD_spisok_add_ZAG(gettext("Ввод новой записи"));
 }



VV.VVOD_spisok_add_MD(gettext("Шифр затрат............."));//0
VV.VVOD_spisok_add_MD(gettext("Тарифная сетка.........."));//1
VV.VVOD_spisok_add_MD(gettext("Норма времени (минуты).."));//2
VV.VVOD_spisok_add_MD(gettext("Расценка (копейки)......"));//3
VV.VVOD_spisok_add_MD(gettext("Код операции............"));//4
VV.VVOD_spisok_add_MD(gettext("Количество (штуки)......"));//5


naz:;


helstr(LINES-1,0,
//"F1","допомога"),
"F2/+",gettext("запись"),
//"F3",gettext("реквизиты"),
"F10",gettext("виход"),NULL);

VV.vramka(-1,-1,0);

for(;;)
 {

  attron(VV.VVOD_return_cs(iceb_CFS)); 

  VV.vprintw(N,stdscr);
  
  K=getch();


  attroff(VV.VVOD_return_cs(iceb_CFS));
  attron(VV.VVOD_return_cs(iceb_CFM));

  VV.vprintw(N,stdscr);

  if(K == KEY_RESIZE)
    goto naz;


  if(K == KEY_MOUSE)
    K=mouseklic(&N,VV.PY,VV.PX,VV.MDLS,VV.KLST,stdscr);

   
  if(K == ENTER)
   {
    attroff(VV.VVOD_return_cs(iceb_CFM));
    attron(VV.VVOD_return_cs(iceb_CFV));
    VV.vprintw_clear(N,stdscr);

    VV.vgetstr(N,stdscr);
    
    attroff(VV.VVOD_return_cs(iceb_CFV));
    attron(VV.VVOD_return_cs(iceb_CFM));

    if(N == 1 && VV.VVOD_spisok_return_data(N)[0] != '\0')
     {
     }

    if(N == 5 && VV.VVOD_spisok_return_data(N)[0] != '\0')
     {
     }

    attroff(VV.VVOD_return_cs(iceb_CFV));
    attron(VV.VVOD_return_cs(iceb_CFM));

    VV.vprintw(N,stdscr);
    N++;
   }
  if(K==SDN) /*Стрелка вниз*/
   {
    N++;
   }
  if(K==SUP) /*Стрелка вверх*/
   {
    N--;
   }
  if(N > VV.KLST-1)
   {
    N=0;
   }
  if(N < 0)
   {
    N=VV.KLST-1;
   }

  if(K == ESC || K == FK10)
   {
    attroff(VV.VVOD_return_cs(iceb_CFS));
    attron(VV.VVOD_return_cs(iceb_CFM));
    N=-1;
    break;
   }

  if(K == FK1) //Помощь
   {
    attroff(VV.VVOD_return_cs(iceb_CFS));
    GDITE();
//    iceb_t_prosf(strsql);
    clear();
    goto naz;
   }

  if(K == FK2 || K == PLU) //Записываем
   {
    if(fort_anz1_zap1(metka_r,mn,gn,nn,nz,podr,&VV) != 0)
     goto naz;
    break;
   }

 }
attroff(VV.VVOD_return_cs(iceb_CFS));
attron(VV.VVOD_return_cs(iceb_CB));
clear();
refresh();
return(0);


return(0);
}
